require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=10
if narray then
  x = NArray.sfloat(n)
  y = NArray.sfloat(n)
else
  x = Array.new(n)
  y = Array.new(n)
end
p=0
h=1.0/n
for i in 0..n-1
  x[i] = p
  y[i] = Math::sin(p)*Math::sqrt(p)
  p = p+h
end


m=n
v = x[n/2]+(x[n/2+1]-x[n/2])/2
eps=1e-6
f,m,eps = SSL2.aklag(x,y,v,m,eps)

printf("f = %12.6e  m = %i  eps = %12.6e\n",f,m,eps)

exact = Math::sin(v)*Math::sqrt(v)
eps = 1e-6
if ((f-exact)/exact).abs > eps then
  printf("Inaccurate result\n");
else
  printf("Result OK\n");
end
