require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=10
if narray then
  x = NArray.sfloat(n)
  y = NArray.sfloat(n)
  dy = NArray.sfloat(n)
else
  x = Array.new(n)
  y = Array.new(n)
  dy = Array.new(n)
end
p=0
pi= Math::PI
h=pi/(n-1)
for i in 0..n-1
  x[i] = p+i+h
  y[i] = Math::sin(x[i])
  dy[i] = Math::cos(x[i])
end


m=n
v = pi/2
eps=1e-6
f,m,eps = SSL2.akher(x,y,dy,v,m,eps)

printf("f = %12.6e  m = %i  eps = %12.6e\n",f,m,eps)

exact = Math::sin(v)
eps = 1e-6
if ((f-exact)/exact).abs > eps then
  printf("Inaccurate result\n");
else
  printf("Result OK\n");
end
