require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=5
if narray then
  d = NArray.sfloat(n)
  sd = NArray.sfloat(n)
else
  d = Array.new(n)
  sd = Array.new(n)
end
for i in 0..n-1
  d[i] = n-i
  sd[i] = (n-i).to_f/2
end


m=n
e,ev = SSL2.teig2(d,sd,m)


for i in 0..m-1
  printf("eigenvalue  %7.4f\n",e[i])
  printf("eigenvector:  ")
  for j in 0..n-1
    if ev.type == NArray then
      printf("%7.4f  ",ev[j,i])
    else
      printf("%7.4f  ",ev[i][j])
    end
  end
  printf("\n")
end
