require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

dim=5
if narray then
  a = NArray.sfloat(dim*(dim+1)/2)
else
  a = Array.new(dim*(dim+1)/2)
end
k=0
for i in 0..dim-1
  for j in 0..i
    a[k] = dim-i
    k += 1
  end
end


m=dim
e,ev = SSL2.seig2(a,m)


for i in 0..m-1
  printf("e-value %d: %10.4f\n",i+1,e[i])
  printf("e-vector:")
  for j in 0..dim-1
    if ev.type == NArray then
      printf("%7.4f  ",ev[j,i])
    else
      printf("%7.4f  ",ev[i][j])
    end
  end
  printf("\n")
end
