require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

dim=5
if narray then
  a = NArray.sfloat(dim*(dim+1)/2)
else
  a = Array.new(dim*(dim+1)/2)
end
k=0
for i in 0..dim-1
  for j in 0..i
    a[k] = dim-i
    k += 1
  end
end


e,ev,m = SSL2.seig1(a)


for i in 0..m-1
  printf("e-value %d: %10.4f\n",i+1,e[i])
  printf("e-vector:")
  if ev.type == NArray then
    for j in 0..dim-1
      printf("%7.4f  ",ev[j,i])
    end
  else
    for j in 0..dim-1
      printf("%7.4f  ",ev[i][j])
    end
  end
  printf("\n")
end

