require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

#     | 1   ,        |
# A = |-1+i , 2      |
#     | 0+2i,-1+i, 1 |

dim=5
if narray then
  a = NArray.sfloat(dim,dim)
  for i in 0..dim-1
    for j in 0..i
      a[j,i] = dim-i
      a[i,j] = dim-1
    end
  end
else
  a = Array.new(dim)
  for i in 0..dim-1
    a[i] = Array.new(dim)
  end
  for i in 0..dim-1
    for j in 0..i
      a[i][j] = dim-i
      a[j][i] = dim-i
    end
  end
end


m=dim
e,ev = SSL2.heig2(a,m)


for i in 0..m-1
  printf("eigenvalue:  %7.4f\n",e[i])
  printf("eigenvector:  ")
  for j in 0..dim-1
    if narray then
      printf("{%7.4f, %7.4f}  ",ev[j,i].real,ev[j,i].image)
    else
      printf("{%7.4f, %7.4f}  ",ev[i][j][0],ev[i][j][1])
    end
  end
  printf("\n")
end

