require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=5
if narray then
  a = NArray.sfloat(n*(n+1)/2)
  b = NArray.sfloat(n*(n+1)/2)
else
  a = Array.new(n*(n+1)/2)
  b = Array.new(n*(n+1)/2)
end
ij=0
for i in 0..n-1
  for j in 0..i-1
    a[ij] = n-i
    b[ij] = 0
    ij += 1
  end
  a[ij] = n-1
  b[ij] = 1
  ij += 1
end

m=n
epsz=0
epst=0
e,ev = SSL2.gseg2(a,b,m,epsz,epst)


for i in 0..m-1
  printf("e-value %d: %10.4f\n",i+1,e[i])
  printf("e-vector:")
  for j in 0..n-1
    if ev.type == NArray then
      printf("%7.4f  ",ev[j,i])
    else
      printf("%7.4f  ",ev[i][j])
    end
  end
  printf("\n")
end

