require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=5
nh=2
m=n
if narray then
  a = NArray.sfloat(n*(nh+1)-nh*(nh+1)/2)
  b = NArray.sfloat(n*(nh+1)-nh*(nh+1)/2)
  ev = NArray.sfloat(n,m)
else
  a = Array.new(n*(nh+1)-nh*(nh+1)/2)
  b = Array.new(n*(nh+1)-nh*(nh+1)/2)
  ev = Array.new(n*m)
end
ij=0
for i in 0..n-1
  jmin = [i-nh,0].max
  for j in jmin..i-1
    a[ij] = n-i
    b[ij] = 0
    ij += 1
  end
  a[ij] = n-1
  b[ij] = 1
  ij += 1
end

for i in 0..m-1
  for j in 0..n-1
    if i==j then
      if narray then
	ev[j,i] = 1
      else
	ev[i][j] = 1
      end
    else
      if narray then
	ev[j,i] = 0
      else
	ev[i][j] = 0
      end
    end
  end
end


lm=1000
epsz=0
epst=0
e,ev,it = SSL2.gbseg(a,b,nh,m,epsz,epst,lm,ev)


printf("it = %d\n",it)
for i in 0..m-1
  printf("e-value %d: %10.4f\n",i+1,e[i])
  printf("e-vector:")
  for j in 0..n-1
    if ev.type == NArray then
      printf("%7.4f  ",ev[j,i])
    else
      printf("%7.4f  ",ev[i][j])
    end
  end
  printf("\n")
end

