require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

dim = 5
if narray then
  a = NArray.sfloat(dim,dim)
  for i in 0..dim-1
    for j in 0..dim-1
      a[j,i] = i-dim
      a[i,j] = dim-1
    end
  end
else
  a = Array.new(dim)
  for i in 0..dim-1
    a[i] = Array.new(dim)
  end
  for i in 0..dim-1
    for j in 0..dim-1
      a[i][j] = i-dim
      a[j][i] = dim-1
    end
  end
end


e,ev = SSL2.eig1(a,0)


i=0
if narray then
  for i in 0..dim-1
    if e[i].image==0 then
      printf("eigenvalue: %7.4f\n",e[i].real)
      printf("eigenvector: ")
      for j in 0..dim-1
	printf("%7.4f  ",ev[j,i])
      end
      printf("\n")
      i += 1
    else
      printf("eigenvalue:  {%7.4f, %7.4f}\n",e[i].real,e[i].image)
      printf("eigenvector:  ")
      for j in 0..dim-1
	printf("{%7.4f, %7.4f}  ",ev[j,i],ev[j,i+1])
      end
      printf("\n")
      printf("eigenvalue:  {%7.4f, %7.4f}\n",e[i+1].real,e[i+1].image)
      printf("eigenvector:  ")
      for j in 0..dim-1
	printf("{%7.4f, %7.4f}  ",ev[j,i],-ev[j,i+1])
      end
    printf("\n")
      i += 2
    end
  end
else
  for i in 0..dim-1
    if e[i][1]==0 then
      printf("eigenvalue: %7.4f\n",e[i][0])
      printf("eigenvector: ")
      for j in 0..dim-1
	printf("%7.4f  ",ev[i][j])
      end
      printf("\n")
      i += 1
    else
      printf("eigenvalue:  {%7.4f, %7.4f}\n",e[i][0],e[i][1])
      printf("eigenvector:  ")
      for j in 0..dim-1
	printf("{%7.4f, %7.4f}  ",ev[i][j],ev[i+1][j])
      end
      printf("\n")
      printf("eigenvalue:  {%7.4f, %7.4f}\n",e[i+1][0],e[i+1][1])
      printf("eigenvector:  ")
      for j in 0..dim-1
	printf("{%7.4f, %7.4f}  ",ev[i][j],-ev[i+1][j])
      end
      printf("\n")
      i += 2
    end
  end
end
