require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

dim=5
if narray then
  za = NArray.scomplex(dim,dim)
  for i in 0..dim-1
    for j in 0..dim-1
      za[j,i] = Complex(i-dim,0)
      za[i,j] = Complex(dim-1,0)
    end
  end
else
  za = Array.new(dim)
  for i in 0..dim-1
    za[i] = Array.new(dim)
  end
  for i in 0..dim-1
    for j in 0..dim-1
      za[i][j] = [i-dim,0]
      za[j][i] = [dim-1,0]
    end
  end      
end


ze,zev = SSL2.ceig2(za,0)

if ze.type == NArray then
  for i in 0..dim-1
    printf("eigenvalue:  {%7.4f,  %7.4f}\n",ze[i].real,ze[i].image)
    printf("eigenvector:  ")
    for j in 0..dim-1
      printf("{%7.4f, %7.4f}  ",zev[j,i].real,zev[j,i].image)
    end
    printf("\n")
  end
else
  for i in 0..dim-1
    printf("eigenvalue:  {%7.4f,  %7.4f}\n",ze[i][0],ze[i][0])
    printf("eigenvector:  ")
    for j in 0..dim-1
      printf("{%7.4f, %7.4f}  ",zev[i][j][0],zev[i][j][1])
    end
    printf("\n")
  end
end
