require "numru/ssl2"
include NumRu

narray = SSL2.with_narray?

n=15
nh=2
m=1
if narray then
  a = NArray.sfloat(n*(nh+1)-nh*(nh+1)/2)
  ev = NArray.sfloat(n,m)
else
  a = Array.new(n*(nh+1)-nh*(nh+1)/2)
  ev = Array.new(m)
  for i in 0..n+1
    ev[i] = Array.new(n)
  end
end
a[0] = 10
a[1] = -3
a[2] = 10
ij = (nh+1)*nh/2
for i in 0..n-nh-1
  a[ij] = -6
  a[ij+1] = -3
  a[ij+2] = 10
  ij = ij+nh+1
end

for i in 0..m-1
  for j in 0..n-1
    if i==j then
      if narray then
	ev[j,i] = 1
      else
	ev[i][j] = 1
      end
    else
      if narray then
	ev[j,i] = 0
      else
	ev[i][j] = 0
      end
    end
  end
end

lm = 1000
epst=1e-6

e,ev,it = SSL2.bsegj(a,nh,m,epst,lm,ev)

printf("it = %d\n",it)
for i in 0..m-1
  printf("eigenvalue:  %7.4f\n",e[i])
  printf("eigenvector:  ")
  for j in 0..n-1
    if narray then
      printf("%7.4f  ",ev[j,i])
    else
      printf("%7.4f  ",ev[i][j])
    end
  end
  printf("\n")
end
