#include <ruby.h>

extern VALUE ruby_class;
VALUE cComplex, cNArray;
VALUE mNumRu;

void init_linear_algebra(VALUE);
void init_eigenvalue_eigenvector(VALUE);
void init_nonlinear_equations(VALUE);
void init_extrema(VALUE);
void init_interpolation_approximation(VALUE);
void init_transforms(VALUE);
void init_numerical_differentiation_quadrature(VALUE);
void init_differential_equations(VALUE);
void init_special_functions(VALUE);
void init_pseudorandom(VALUE);

static VALUE
rb_with_narray(self)
     VALUE self;
{
#ifdef HAVE_NARRAY_H
  return Qtrue;
#else
  return Qfalse;
#endif
}

void Init_ssl2()
{

  VALUE mSSL2;
  ID id;

  rb_require("complex");
#ifdef HAVE_NARRAY_H
  rb_require("narray");
#endif

  cNArray = rb_const_get(ruby_class, rb_intern("NArray"));
  cComplex = rb_const_get(ruby_class, rb_intern("Complex"));

  id = rb_intern("NumRu");
  if (rb_const_defined_at(ruby_class, id)) {
      mNumRu = rb_const_get(ruby_class, id);
  }
  if (mNumRu) {
      if (TYPE(mNumRu) != T_MODULE) {
          rb_raise(rb_eTypeError, "%s is not a module",
                   rb_id2name(id));
      }
      if (rb_safe_level() >= 4) {
          rb_raise(rb_eSecurityError, "extending module prohibited");
      }
  }
  else {
      mNumRu = rb_define_module("NumRu");
  }

  mSSL2 = rb_define_module_under(mNumRu, "SSL2");



  rb_define_module_function(mSSL2, "with_narray?", rb_with_narray, 0);

  init_linear_algebra(mSSL2);
  init_eigenvalue_eigenvector(mSSL2);
  init_nonlinear_equations(mSSL2);
  init_extrema(mSSL2);
  init_interpolation_approximation(mSSL2);
  init_transforms(mSSL2);
  init_numerical_differentiation_quadrature(mSSL2);
  init_differential_equations(mSSL2);
  init_special_functions(mSSL2);
  init_pseudorandom(mSSL2);
}
