require 'narray'
require 'netcdfraw'

# NetCDF$B%/%i%9$K4X$7$F(B
class NetCDF

   def NetCDF.open(filename,mode="r",share=false)
      case(mode)
      when "r"
	 mode=NC_NOWRITE
      when "w"
	 mode=NC_WRITE
      else
	 raise NetcdfError, "We can't use the mode you typed"
      end
      case(share)
      when false
	 share=0
      when true
	 share=NC_SHARE
      else
	 raise NetcdfError, "We can't use the sharing mode you typed"
      end
      omode=mode | share
      nc_open(filename,omode)
   end
   
   class << NetCDF
      alias new open
   end
   

   def NetCDF.create(filename,noclobber=false,share=false)
      case(noclobber)
      when false
	 noclobber=0
      when true
	 noclobber=0x4
      else
	 raise NetcdfError,"We can't use the creation mode you
    typed"
      end
      case(share)
      when false
	 share=0
      when true
	 share=0x0800
      else
	 raise NetcdfError,"We can't use the sharing mode you
    typed"
      end
      
      cmode=noclobber | share
      nc_create(filename,cmode)
   end

   def put_att(attname,val=nil,atttype=nil)
      if atttype == nil
	 if val != Array && !val.is_a?(String)
	    put_attraw(attname,Array(val),nil)
	 else
	    put_attraw(attname,val,nil)
	 end
      else
	 if val != Array && !val.is_a?(String)
	    put_attraw(attname,Array(val),atttype)
	 else 
	    put_attraw(attname,val,atttype)
	 end
      end
   end


   #$B%$%F%l!<%?4X78(B	 
   def each_dim
      num_dim=ndims()    
      for dimid in 0..num_dim-1
	 obj_Dim=id2dim(dimid)
	 yield(obj_Dim)
      end
   end
   
   def each_var
      num_var=nvars()
      for varid in 0..num_var-1
	 obj_Var=id2var(varid)
	 yield(obj_Var)
      end
   end

   def each_att
      num_att=natts()
      for attnum in 0..num_att-1
	 obj_Att=id2att(attnum)
	 yield(obj_Att)
      end
   end
   
   def dim_names
      num_dim=ndims()
      names=[]
      for dimid in 0..num_dim-1
	 obj_Dim=id2dim(dimid)    
	 names=names+[obj_Dim.name]
      end
      return names	
   end    

   def var_names
      num_var=nvars()
      names=[]
      for varid in 0..num_var-1
	 obj_Var=id2var(varid)
	 names=names+[obj_Var.name]
      end
      return names
   end

   def att_names
      num_att=natts()
      names=[]
      for attnum in 0..num_att-1
	 obj_Att=id2att(attnum)    
	 names=names+[obj_Att.name]
      end
      return names
   end

   alias :uri :path
   
   def inspect
      "NetCDF:"+uri
   end
   
end

#NetCDFVar class $B$K4X$7$F(B
class NetCDFVar

   def each_att
      num_att=natts()
      for attnum in 0..num_att-1
	 obj_Att=id2att(attnum)
	 yield(obj_Att)
      end
   end

   def dim_names
      ary = Array.new()
      dims.each{|dim| ary.push(dim.name)}
      ary
   end

   def att_names
      num_att=natts()
      names=[]
      for attnum in 0..num_att-1
	 obj_Att=id2att(attnum)
	 names=names+[obj_Att.name]
      end
      return names
   end

   def put_att(attname,val=nil,atttype=nil)
      if atttype == nil
	 if val != Array && !val.is_a?(String)
	    put_attraw(attname,Array(val),nil)
	 else
	    put_attraw(attname,val,nil)
	 end
      else
	 if val != Array && !val.is_a?(String)
	    put_attraw(attname,Array(val),atttype)
	 else 
	    put_attraw(attname,val,atttype)
	 end
      end
   end

   # The put and get methods in the NetCDFVar class
   
   def put(var,hash=nil)
      if hash==nil
	 if self.vartype == "byte"
	    put_var_byte(var)
	 elsif self.vartype == "sint"
	    put_var_sint(var)
	 elsif self.vartype == "int"
	    put_var_int(var)
	 elsif self.vartype == "sfloat"
	    put_var_sfloat(var)
	 elsif self.vartype == "float"
	    put_var_float(var)
	 else 
	    raise NetcdfError,"variable type isn't supported in netCDF" 
	 end
      elsif hash.key?("index")==true 
	 if self.vartype=="byte"
	    put_var1_byte(var,hash["index"])
	 elsif self.vartype=="sint"
	    put_var1_sint(var,hash["index"])
	 elsif self.vartype == "int"
	    put_var1_int(var,hash["index"])
	 elsif self.vartype == "sfloat"
	    put_var1_sfloat(var,hash["index"])
	 elsif self.vartype == "float"
	    put_var1_float(var,hash["index"])
	 else 
	    raise NetcdfError,"variable type isn't supported in netCDF"
	 end
      elsif hash.key?("start")==true
	 if hash.key?("end")==false && hash.key?("stride")==false
	    if self.vartype=="byte"
	       put_vars_byte(var,hash["start"],nil,nil)
	    elsif self.vartype=="sint"
	       put_vars_sint(var,hash["start"],nil,nil)
	    elsif self.vartype=="int"
	       put_vars_int(var,hash["start"],nil,nil)
	    elsif self.vartype=="sfloat"
	       put_vars_sfloat(var,hash["start"],nil,nil)
	    elsif self.vartype=="float"
	       put_vars_float(var,hash["start"],nil,nil)
	    else
	       raise NetcdfError, "variable type isn't supported in netCDF"
	    end
	 elsif hash.key?("end")==true && hash.key?("stride") == false
	    if self.vartype=="byte"
	       put_vars_byte(var,hash["start"],hash["end"],nil)
	    elsif self.vartype=="sint"
	       put_vars_sint(var,hash["start"],hash["end"],nil)
	    elsif self.vartype=="int"
	       put_vars_int(var,hash["start"],hash["end"],nil)
	    elsif self.vartype == "sfloat"
	       put_vars_sfloat(var,hash["start"],hash["end"],nil)
	    elsif self.vartype =="float"
	       put_vars_float(var,hash["start"],hash["end"],nil)
	    else
	       raise NetcdfError, "variable type isn't supported in netCDF"
	    end
	 elsif hash.key?("end")==false && hash.key?("stride")==true
	    if self.vartype=="byte"
	       put_vars_byte(var,hash["start"],nil,hash["stride"])
	    elsif self.vartype=="sint"
	       put_vars_sint(var,hash["start"],nil,hash["stride"])
	    elsif self.vartype=="int"
	       put_vars_int(var,hash["start"],nil,hash["stride"])
	    elsif self.vartype=="sfloat"
	       put_vars_sfloat(var,hash["start"],nil,hash["stride"])
	    elsif self.vartype=="float"
	       put_vars_float(var,hash["start"],nil,hash["stride"])
	    else
	       raise NetcdfError, "variable type isn't supported in netCDF"
	    end
	 else hash.key?("end")==true && hash.key?("stride")==true
	    if self.vartype=="byte"
	       put_vars_byte(var,hash["start"],hash["end"],hash["stride"])
	    elsif self.vartype=="sint"
	       put_vars_sint(var,hash["start"],hash["end"],hash["stride"])
	    elsif self.vartype=="int"
	       put_vars_int(var,hash["start"],hash["end"],hash["stride"])
	    elsif self.vartype=="sfloat"
	       put_vars_sfloat(var,hash["start"],hash["end"],hash["stride"])
	    elsif self.vartype=="float"
	       put_vars_float(var,hash["start"],hash["end"],hash["stride"])
	    else
	       raise NetcdfError, "variable type isn't supported in netCDF"
	    end
	 end
      else
	 raise NetcdfError,"{'start'}=>[ARRAY] or {'index'}=>[ARRAY] is needed"
      end
   end
   
   def get(hash=nil)
      t_var = self.vartype
      if hash == nil
	 if t_var == "byte"
	    get_var_byte
	 elsif t_var == "sint"
	    get_var_byte
	 elsif t_var == "int"
	    get_var_int
	 elsif t_var == "sfloat"
	    get_var_sfloat
	 elsif t_var == "float"
	    get_var_float
	 else
	    raise NetcdfError, "variable type isn't supported in netCDF"
	 end
      elsif hash.key?("index")==true
	 ind = hash["index"]
	 if t_var == "byte"
	    get_var1_byte(ind)
	 elsif t_var == "sint"
	    get_var1_sint(ind)
	 elsif t_var == "int"
	    get_var1_int(ind)
	 elsif t_var == "sfloat"
	    get_var1_sfloat(ind)
	 elsif t_var == "float"
	    get_var1_float(ind)
	 else
	    raise NetcdfError,"variable type isn't supported in netCDF"
	 end
      elsif hash.key?("start")==true
	 h_sta = hash["start"]
	 endq = hash.key?("end")
	 strq = hash.key?("stride")
	 if endq == false && strq == false
	    if t_var == "byte"
	       get_vars_byte(h_sta,nil,nil)
	    elsif t_var == "sint" 
	       get_vars_sint(h_sta,nil,nil)
	    elsif t_var == "int"
	       get_vars_int(h_sta,nil,nil)
	    elsif t_var == "sfloat"
	       get_vars_sfloat(h_sta,nil,nil)
	    elsif t_var == "float"
	       get_vars_float(h_sta,nil,nil)
	    else 
	       raise NetcdfError "varialbe type isn't supported in netCDF"
	    end
	 elsif endq == true && strq == false
	    h_end = hash["end"]
	    if t_var == "byte"
	       get_vars_byte(h_sta,h_end,nil)
	    elsif t_var == "sint"
	       get_vars_sint(h_sta,h_end,nil)
	    elsif t_var == "int"
	       get_vars_int(h_sta,h_end,nil)
	    elsif t_var == "sfloat"
	       get_vars_sfloat(h_sta,h_end,nil)
	    elsif t_var == "float"
	       get_vars_float(h_sta,h_end,nil)
	    else
	       raise NetcdfError, "variable type isn't supported in netCDF"
	    end
	 elsif endq == false && strq == true
	    h_str = hash["stride"]
	    if t_var == "byte"
	       get_vars_byte(h_sta,nil,h_str)
	    elsif t_var == "sint"
	       get_vars_sint(h_sta,nil,h_str)
	    elsif t_var == "int"
	       get_vars_int(h_sta,nil,h_str)
	    elsif t_var == "sfloat"
	       get_vars_sfloat(h_sta,nil,h_str)
	    elsif t_var == "float"
	       get_vars_float(h_sta,nil,h_str)
	    else
	       raise NetcdfError, "variable type isn't supported in netCDF"
	    end
      else endq == true && strq == true
	    h_end = hash["end"]
	    h_str = hash["stride"]
	    if t_var == "byte"
	       get_vars_byte(h_sta,h_end,h_str)
	    elsif t_var == "sint"
	       get_vars_sint(h_sta,h_end,h_str)
	    elsif t_var == "int"
	       get_vars_int(h_sta,h_end,h_str)
	    elsif t_var == "sfloat"
	       get_vars_sfloat(h_sta,h_end,h_str)
	    elsif t_var == "float"
	       get_vars_float(h_sta,h_end,h_str)
	    else
	       raise NetcdfError, "variable type isn't supported in netCDF"
	    end
	 end
      else
	 raise NetcdfError,"{'start'}=>{ARRAY} or {'index'}=>{ARRAY} is needed"
      end
   end
   
   def uri
      file.uri+'?'+name
   end
   
   def inspect
      'NetCDFVar:'+uri
   end

end

class NetCDFAtt
   
   def put(val=nil,atttype=nil)
      if atttype == nil
	 if val != Array && !val.is_a?(String)
	    putraw(Array(val),nil)
	 else
	    putraw(val,nil)
	 end
      else
	 if val != Array && !val.is_a?(String)
	    putraw(Array(val),atttype)
	 else 
	    putraw(val,atttype)
	 end
      end
   end
   
   def inspect
      'NetCDFAtt:'+name
   end
end

class NetCDFDim
   def inspect
      'NetCDFDim:'+name
   end
end
