
def set_uchar(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_set_#{name}(VALUE self, VALUE val)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  p->#{klass}->#{name} = (unsigned char) NUM2INT(val);
  return self;
}
EOF
  return str
end
def get_uchar(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_get_#{name}(VALUE self)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  return CHR2FIX((char)p->#{klass}->#{name});
}
EOF
  return str
end
def set_puchar(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_set_#{name}(VALUE self, VALUE val)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  p->#{klass}->#{name} = (unsigned char*)STR2CSTR(val);
  p->#{name} = val;
  return self;
}
EOF
  return str
end
def set_pchar(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_set_#{name}(VALUE self,VALUE val)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  p->#{klass}->#{name} = STR2CSTR(val);
  p->#{name} = val;
  return self;
}
EOF
  return str
end
def get_pchar(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_get_#{name}(VALUE self)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  return rb_str_new2(p->#{klass}->#{name});
}
EOF
  return str
end
def set_uint(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_set_#{name}(VALUE self, VALUE val)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  p->#{klass}->#{name} = (uint) NUM2INT(val);
  return self;
}
EOF
  return str
end
def get_uint(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_get_#{name}(VALUE self)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  return INT2NUM((unsigned int)p->#{klass}->#{name});
}
EOF
  return str
end
def set_int(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_set_#{name}(VALUE self, VALUE val)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  p->#{klass}->#{name} = NUM2INT(val);
  return self;
}
EOF
  return str
end
def get_int(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_get_#{name}(VALUE self)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  return INT2NUM(p->#{klass}->#{name});
}
EOF
  return str
end
def get_char(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_get_#{name}(VALUE self)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  return CHR2FIX(p->#{klass}->#{name});
}
EOF
  return str
end
def get_float(klass, name)
  str =<<"EOF"
static VALUE
rb_#{klass}_get_#{name}(VALUE self)
{
  rb_#{klass} *p;
  Data_Get_Struct(self,rb_#{klass},p);
  return rb_float_new((double) p->#{klass}->#{name});
}
EOF
  return str
end

def mark_free(klass,objs)
  str =<<"EOF"
static void
mark_#{klass}(void *p0)
{
  rb_#{klass} *p;

  p = (rb_#{klass}*)p0;
EOF
  objs.each{|o|
    str << "  if(p->#{o}) rb_gc_mark(p->#{o});\n"
  }
  str +=<<"EOF"
}
static void
free_#{klass}(void *p0)
{
  rb_#{klass} *p;

  p = (rb_#{klass}*)p0;
  free(p->#{klass});
  free(p);
}
EOF
  return str
end




fname = "libfame.c"
file = File.open(fname,"w")

file.print <<"EOF"
#include <stdio.h>
#include "ruby.h"
#include "fame.h"

static VALUE mLibFAME;
static VALUE cYuv;
static VALUE cFrame_statistics;
static VALUE cParameters;
static VALUE cObject;
static VALUE cFame;

typedef struct _rb_yuv {
  fame_yuv_t *yuv;
  VALUE y;
  VALUE u;
  VALUE v;
} rb_yuv;

typedef struct _rb_frame_statistics {
  fame_frame_statistics_t *frame_statistics;
} rb_frame_statistics;

typedef struct _rb_parameters {
  fame_parameters_t *parameters;
  VALUE coding;
  VALUE profile;
} rb_parameters;

typedef struct _rb_object {
  fame_object_t *object;
} rb_object;

typedef struct _rb_fame {
  fame_context_t *context;
  VALUE parameters;
  unsigned char *buffer;
  char flag;
} rb_fame;

EOF


%w(w h p).each{|s|
  file.print set_int("yuv",s)
  file.print get_int("yuv",s)
}
%w(y u v).each{|s|
  file.print set_puchar("yuv",s)
}

%w(frame_number actual_bits spatial_activity).each{|s|
  file.print get_uint("frame_statistics",s)
}
%w(coding).each{|s|
  file.print get_char("frame_statistics",s)
}
%w(target_bits).each{|s|
  file.print get_int("frame_statistics",s)
}
%w(quant_scale).each{|s|
  file.print get_float("frame_statistics",s)
}

%w(frames_per_sequence search_range total_frames).each{|s|
  file.print set_uint("parameters",s)
  file.print get_uint("parameters",s)
}
%w(width height quality bitrate slices_per_frame frame_rate_num frame_rate_den shape_quality).each{|s|
  file.print set_int("parameters",s)
  file.print get_int("parameters",s)
}
%w(coding profile).each{|s|
  file.print set_pchar("parameters",s)
  file.print get_pchar("parameters",s)
}
%w(verbose).each{|s|
  file.print set_uchar("parameters",s)
  file.print get_uchar("parameters",s)
}

%w(name).each{|s|
  file.print get_pchar("object",s)
}


file.print mark_free("yuv",%w(y u v))
file.print <<"EOF"
static VALUE
rb_yuv_new(VALUE klass)
{
  rb_yuv *p;
  p = ALLOC(rb_yuv);
  p->yuv = ALLOC(fame_yuv_t);
  p->yuv->w = 0;
  p->yuv->h = 0;
  p->yuv->p = 0;
  p->yuv->y = NULL;
  p->yuv->u = NULL;
  p->yuv->v = NULL;
  p->y = 0;
  p->u = 0;
  p->v = 0;
  return Data_Wrap_Struct(klass,mark_yuv,free_yuv,p);
}
EOF

file.print mark_free("frame_statistics",[])

file.print mark_free("parameters",%w(coding profile))
file.print <<"EOF"
static VALUE
rb_parameters_new(VALUE klass)
{
  rb_parameters *p;
  p = ALLOC(rb_parameters);
  p->parameters = ALLOC(fame_parameters_t);
  p->parameters->width = 352;
  p->parameters->height = 288;
  p->parameters->coding = "I";
  p->parameters->quality = 75;
  p->parameters->bitrate = 0;
  p->parameters->slices_per_frame = 1;
  p->parameters->frames_per_sequence = 0xffffffff;
  p->parameters->frame_rate_num = 25;
  p->parameters->frame_rate_den = 1;
  p->parameters->shape_quality = 100;
  p->parameters->search_range = 0;
  p->parameters->verbose = 1;
  p->parameters->profile = "mpeg4";
  p->parameters->total_frames = 0;
  p->parameters->retrieve_cb = NULL;
  p->coding = 0;
  p->profile = 0;
  return Data_Wrap_Struct(klass,mark_parameters,free_parameters,p);
};
EOF

file.print mark_free("object",[])

file.print <<"EOF"
static VALUE
rb_yuv_from_rgb(VALUE self, VALUE str)
{
  rb_yuv *yuv;
  unsigned char *y, *u, *v;
  unsigned char *rgb;
  int w, h;
  long len;
  int i,j;
  int ii,jj;

  Data_Get_Struct(self,rb_yuv,yuv);
  w = yuv->yuv->w;
  h = yuv->yuv->h;

  rgb = rb_str2cstr(str, &len);
  if ( len!=w*h*3 )
    rb_raise(rb_eArgError,"rbg.length(%d) must be width(%d) * height(%d) * 3",len,w,h);

  len = w*h;

  y = ALLOC_N(unsigned char, len);
  u = ALLOC_N(unsigned char, len/4);
  v = ALLOC_N(unsigned char, len/4);

  for (i=0;i<len;i++)
    y[i] = 0.257*rgb[i*3] + 0.504*rgb[i*3+1] + 0.098*rgb[i*3+1] +16;
  for (j=0;j<h/2;j++)
    for (i=0;i<w/2;i++) {
      ii = i+j*w/2;
      jj = (i*2+j*2*w)*3;
      u[ii] = -0.148*rgb[jj] -0.291*rgb[jj+1] +0.439*rgb[jj+2] +128;
      jj = (i*2+(j*2+1)*w)*3;
      v[ii] = 0.439*rgb[jj] -0.368*rgb[jj+1] -0.071*rgb[jj+2] +128;
    }

  yuv->yuv->y = y;
  yuv->yuv->u = u;
  yuv->yuv->v = v;

  yuv->y = 0;
  yuv->u = 0;
  yuv->v = 0;

  return self;
}
EOF

file.print <<"EOF"
static VALUE
rb_parameters_inspect(VALUE self)
{
  rb_parameters *rp;
  fame_parameters_t *p;

  Data_Get_Struct(self,rb_parameters,rp);
  p = rp->parameters;
  printf("width=%d, height=%d, coding=%s, quality=%d, bitrate=%d, slices_per_frame=%d, frames_per_sequence=%u, frame_rate_num=%d, frame_rate_den=%d, shape_quality=%d, search_range=%u, verbose=%u, profile=%s, total_frames=%u", p->width, p->height, p->coding, p->quality, p->bitrate, p->slices_per_frame, p->frames_per_sequence, p->frame_rate_num, p->frame_rate_den, p->shape_quality, p->search_range, p->verbose, p->profile, p->total_frames);
  return Qnil;
}
static VALUE
rb_frame_statistics_inspect(VALUE self)
{
  rb_frame_statistics *rp;
  fame_frame_statistics_t *p;

  Data_Get_Struct(self,rb_frame_statistics,rp);
  p = rp->frame_statistics;
  printf("frame_number=%u, coding=%c, target_bits=%d, actual_bits=%u, spatial_activity=%u, quant_scale=%f",p->frame_number, p->coding, p->target_bits, p->actual_bits, p->spatial_activity, p->quant_scale);
  return Qnil;
}
EOF

file.print <<"EOF"
static void
mark_fame(void *p0)
{
  rb_fame *p;

  p = (rb_fame*)p0;
  rb_gc_mark(p->parameters);
}
static void
free_fame(void *p0)
{
  rb_fame *p;

  p = (rb_fame*)p0;
  if (p->flag) fame_close(p->context);
  if (p->buffer) free(p->buffer);
  free(p);
}
static VALUE
rb_fame_new(VALUE klass)
{
  rb_fame *p;
  fame_context_t *context;

  context = fame_open();
  if (!context)
    rb_raise(rb_eRuntimeError,"fame cannot open (fame_open)");
  p = ALLOC(rb_fame);
  p->context = context;
  p->flag = 1;
  return Data_Wrap_Struct(klass, mark_fame, free_fame, p);
}

static VALUE
rb_fame_init(VALUE self, VALUE params, VALUE rsize)
{
  rb_fame *p;
  rb_parameters *rparams;
  unsigned char *buffer;
  int size;

  if (CLASS_OF(params)!=cParameters)
    rb_raise(rb_eArgError,"argument must be LibFAME::Parameters");
  Data_Get_Struct(params,rb_parameters,rparams);
  size = NUM2INT(rsize);
  buffer = ALLOC_N(unsigned char,size);
  Data_Get_Struct(self,rb_fame,p);
  fame_init(p->context, rparams->parameters, buffer, size);
  p->parameters = params;
  p->buffer = buffer;

  return self;
}

static VALUE
rb_fame_register(VALUE self,VALUE type,VALUE object)
{
  rb_fame *p;
  rb_object *obj;
  ID id;

  id = rb_intern(STR2CSTR(type));
  if (CLASS_OF(object)!=cObject)
    rb_raise(rb_eArgError,"second argument must be LibFAME::Object");
  Data_Get_Struct(object,rb_object,obj);
  Data_Get_Struct(self,rb_fame,p);
  fame_register(p->context,rb_id2name(id),obj->object);
  return Qnil;
}

static VALUE
rb_fame_unregister(VALUE self,VALUE type)
{
  rb_fame *p;

  Data_Get_Struct(self,rb_fame,p);
  fame_unregister(p->context,STR2CSTR(type));
  return Qnil;
}

static VALUE
rb_fame_get_object(VALUE self,VALUE type)
{
  rb_fame *p;
  rb_object *obj;
  fame_object_t *cobj;
  ID id;

  id = rb_intern(STR2CSTR(type));
  cobj = ALLOC(fame_object_t);
  Data_Get_Struct(self,rb_fame,p);
  cobj = fame_get_object(p->context,rb_id2name(id));
  if (!cobj)
    rb_raise(rb_eRuntimeError,"%s is not found",rb_id2name(id));
  obj = ALLOC(rb_object);
  obj->object = cobj;
  return Data_Wrap_Struct(cObject,mark_object,free_object,obj);
}

static VALUE
rb_fame_start_frame(int argc, VALUE *argv, VALUE self)
{
  VALUE ryuv;
  VALUE rmask;
  rb_fame *p;
  rb_yuv *yuv;
  unsigned char *mask = NULL;

  rb_scan_args(argc, argv, "11", &ryuv, &rmask);
  if (argc==2)
    mask = STR2CSTR(rmask);

  if (CLASS_OF(ryuv)!=cYuv)
    rb_raise(rb_eArgError, "first argument must be LibFAME::Yuv");
  Data_Get_Struct(ryuv,rb_yuv,yuv);

  Data_Get_Struct(self,rb_fame,p);
  fame_start_frame(p->context,yuv->yuv,mask);
  return Qnil;
}

static VALUE
rb_fame_encode_slice(VALUE self)
{
  rb_fame *p;
  int len;

  Data_Get_Struct(self,rb_fame,p);
  len = fame_encode_slice(p->context);
  return rb_str_new(p->buffer,len);
}
  
static VALUE
rb_fame_end_frame(VALUE self)
{
  rb_fame *p;
  rb_frame_statistics *rstat;
  fame_frame_statistics_t *stat;

  Data_Get_Struct(self,rb_fame,p);
  stat = ALLOC(fame_frame_statistics_t);
  fame_end_frame(p->context,stat);
  rstat = ALLOC(rb_frame_statistics);
  rstat->frame_statistics = stat;
  return Data_Wrap_Struct(cFrame_statistics,mark_frame_statistics,free_frame_statistics,rstat);
}

static VALUE
rb_fame_encode_frame(int argc, VALUE *argv, VALUE self)
{
  VALUE ryuv;
  VALUE rmask;
  rb_fame *p;
  rb_yuv *yuv;
  unsigned char *mask = NULL;
  int len;

  rb_scan_args(argc, argv, "11", &ryuv, &rmask);
  if (argc==2)
    mask = STR2CSTR(rmask);

  if (CLASS_OF(ryuv)!=cYuv)
    rb_raise(rb_eArgError, "first argument must be LibFAME::Yuv");
  Data_Get_Struct(ryuv,rb_yuv,yuv);

  Data_Get_Struct(self,rb_fame,p);
  len = fame_encode_frame(p->context,yuv->yuv,mask);
  return rb_str_new(p->buffer,len);
}

static VALUE
rb_fame_close(VALUE self)
{
  rb_fame *p;
  int len;

  Data_Get_Struct(self,rb_fame,p);
  len = fame_close(p->context);
  p->flag = 0;
  return INT2NUM(len);
}

EOF

file.print <<"EOF"

void Init_libfame()
{
  mLibFAME = rb_define_module("LibFAME");
  rb_define_const(mLibFAME,"Version",rb_ary_new3(3,INT2NUM(LIBFAME_MAJOR_VERSION),INT2NUM(LIBFAME_MINOR_VERSION),INT2NUM(LIBFAME_MICRO_VERSION)));

  cYuv = rb_define_class_under(mLibFAME, "Yuv", rb_cObject);
  rb_define_singleton_method(cYuv,"new",rb_yuv_new,0);

  cFrame_statistics = rb_define_class_under(mLibFAME, "Frame_statistics", rb_cObject);

  cParameters = rb_define_class_under(mLibFAME, "Parameters", rb_cObject);
  rb_define_singleton_method(cParameters,"new",rb_parameters_new,0);

  cObject = rb_define_class_under(mLibFAME, "Object", rb_cObject);

  cFame = rb_define_class_under(mLibFAME, "Fame", rb_cObject);
  rb_define_singleton_method(cFame,"new",rb_fame_new,0);
  rb_define_singleton_method(cFame,"open",rb_fame_new,0);


EOF
%w(w h p).each{|s|
  file.print "  rb_define_method(cYuv,\"set_#{s}\",rb_yuv_set_#{s},1);\n"
  file.print "  rb_define_alias(cYuv,\"#{s}=\",\"set_#{s}\");\n"
  file.print "  rb_define_method(cYuv,\"get_#{s}\",rb_yuv_get_#{s},0);\n"
  file.print "  rb_define_alias(cYuv,\"#{s}\",\"get_#{s}\");\n"
}
%w(y u v).each{|s|
  file.print "  rb_define_method(cYuv,\"set_#{s}\",rb_yuv_set_#{s},1);\n"
  file.print "  rb_define_alias(cYuv,\"#{s}=\",\"set_#{s}\");\n"
}
file.print "  rb_define_method(cYuv,\"from_rgb\",rb_yuv_from_rgb,1);\n"

%w(frame_number coding target_bits actual_bits spatial_activity quant_scale).each{|s|
  file.print "  rb_define_method(cFrame_statistics,\"get_#{s}\",rb_frame_statistics_get_#{s},1);\n"
  file.print "  rb_define_alias(cFrame_statistics,\"#{s}\",\"get_#{s}\");\n"
}
file.print "  rb_define_method(cFrame_statistics,\"inspect\",rb_frame_statistics_inspect,0);\n"

%w(width height coding quality bitrate slices_per_frame frames_per_sequence frame_rate_num frame_rate_den shape_quality search_range verbose profile total_frames).each{|s|
  file.print "  rb_define_method(cParameters,\"set_#{s}\",rb_parameters_set_#{s},1);\n"
  file.print "  rb_define_alias(cParameters,\"#{s}=\",\"set_#{s}\");\n"
  file.print "  rb_define_method(cParameters,\"get_#{s}\",rb_parameters_get_#{s},0);"
  file.print "  rb_define_alias(cParameters,\"#{s}\",\"get_#{s}\");\n"
}
file.print "  rb_define_method(cParameters,\"inspect\",rb_parameters_inspect,0);\n"

%w(name).each{|s|
  file.print "  rb_define_method(cObject,\"get_#{s}\",rb_object_get_#{s},0);\n"
  file.print "  rb_define_alias(cObject,\"#{s}\",\"get_#{s}\");\n"
}

file.print <<"EOF"
  rb_define_method(cFame,"init",rb_fame_init,2);
  rb_define_method(cFame,"register",rb_fame_register,2);
  rb_define_method(cFame,"unregister",rb_fame_unregister,1);
  rb_define_method(cFame,"get_object",rb_fame_get_object,1);
  rb_define_method(cFame,"start_frame",rb_fame_start_frame,-1);
  rb_define_method(cFame,"encode_slice",rb_fame_encode_slice,0);
  rb_define_method(cFame,"end_frame",rb_fame_end_frame,0);
  rb_define_method(cFame,"encode_frame",rb_fame_encode_frame,-1);
  rb_define_method(cFame,"close",rb_fame_close,0);
}
EOF
