#include <stdio.h>
#include "ruby.h"
#include "fame.h"

static VALUE mLibFAME;
static VALUE cYuv;
static VALUE cFrame_statistics;
static VALUE cParameters;
static VALUE cObject;
static VALUE cFame;

typedef struct _rb_yuv {
  fame_yuv_t *yuv;
  VALUE y;
  VALUE u;
  VALUE v;
} rb_yuv;

typedef struct _rb_frame_statistics {
  fame_frame_statistics_t *frame_statistics;
} rb_frame_statistics;

typedef struct _rb_parameters {
  fame_parameters_t *parameters;
  VALUE coding;
  VALUE profile;
} rb_parameters;

typedef struct _rb_object {
  fame_object_t *object;
} rb_object;

typedef struct _rb_fame {
  fame_context_t *context;
  VALUE parameters;
  unsigned char *buffer;
  char flag;
} rb_fame;

static VALUE
rb_yuv_set_w(VALUE self, VALUE val)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  p->yuv->w = NUM2INT(val);
  return self;
}
static VALUE
rb_yuv_get_w(VALUE self)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  return INT2NUM(p->yuv->w);
}
static VALUE
rb_yuv_set_h(VALUE self, VALUE val)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  p->yuv->h = NUM2INT(val);
  return self;
}
static VALUE
rb_yuv_get_h(VALUE self)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  return INT2NUM(p->yuv->h);
}
static VALUE
rb_yuv_set_p(VALUE self, VALUE val)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  p->yuv->p = NUM2INT(val);
  return self;
}
static VALUE
rb_yuv_get_p(VALUE self)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  return INT2NUM(p->yuv->p);
}
static VALUE
rb_yuv_set_y(VALUE self, VALUE val)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  p->yuv->y = (unsigned char*)STR2CSTR(val);
  p->y = val;
  return self;
}
static VALUE
rb_yuv_set_u(VALUE self, VALUE val)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  p->yuv->u = (unsigned char*)STR2CSTR(val);
  p->u = val;
  return self;
}
static VALUE
rb_yuv_set_v(VALUE self, VALUE val)
{
  rb_yuv *p;
  Data_Get_Struct(self,rb_yuv,p);
  p->yuv->v = (unsigned char*)STR2CSTR(val);
  p->v = val;
  return self;
}
static VALUE
rb_frame_statistics_get_frame_number(VALUE self)
{
  rb_frame_statistics *p;
  Data_Get_Struct(self,rb_frame_statistics,p);
  return INT2NUM((unsigned int)p->frame_statistics->frame_number);
}
static VALUE
rb_frame_statistics_get_actual_bits(VALUE self)
{
  rb_frame_statistics *p;
  Data_Get_Struct(self,rb_frame_statistics,p);
  return INT2NUM((unsigned int)p->frame_statistics->actual_bits);
}
static VALUE
rb_frame_statistics_get_spatial_activity(VALUE self)
{
  rb_frame_statistics *p;
  Data_Get_Struct(self,rb_frame_statistics,p);
  return INT2NUM((unsigned int)p->frame_statistics->spatial_activity);
}
static VALUE
rb_frame_statistics_get_coding(VALUE self)
{
  rb_frame_statistics *p;
  Data_Get_Struct(self,rb_frame_statistics,p);
  return CHR2FIX(p->frame_statistics->coding);
}
static VALUE
rb_frame_statistics_get_target_bits(VALUE self)
{
  rb_frame_statistics *p;
  Data_Get_Struct(self,rb_frame_statistics,p);
  return INT2NUM(p->frame_statistics->target_bits);
}
static VALUE
rb_frame_statistics_get_quant_scale(VALUE self)
{
  rb_frame_statistics *p;
  Data_Get_Struct(self,rb_frame_statistics,p);
  return rb_float_new((double) p->frame_statistics->quant_scale);
}
static VALUE
rb_parameters_set_frames_per_sequence(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->frames_per_sequence = (uint) NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_frames_per_sequence(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM((unsigned int)p->parameters->frames_per_sequence);
}
static VALUE
rb_parameters_set_search_range(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->search_range = (uint) NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_search_range(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM((unsigned int)p->parameters->search_range);
}
static VALUE
rb_parameters_set_total_frames(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->total_frames = (uint) NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_total_frames(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM((unsigned int)p->parameters->total_frames);
}
static VALUE
rb_parameters_set_width(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->width = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_width(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->width);
}
static VALUE
rb_parameters_set_height(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->height = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_height(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->height);
}
static VALUE
rb_parameters_set_quality(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->quality = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_quality(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->quality);
}
static VALUE
rb_parameters_set_bitrate(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->bitrate = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_bitrate(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->bitrate);
}
static VALUE
rb_parameters_set_slices_per_frame(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->slices_per_frame = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_slices_per_frame(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->slices_per_frame);
}
static VALUE
rb_parameters_set_frame_rate_num(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->frame_rate_num = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_frame_rate_num(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->frame_rate_num);
}
static VALUE
rb_parameters_set_frame_rate_den(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->frame_rate_den = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_frame_rate_den(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->frame_rate_den);
}
static VALUE
rb_parameters_set_shape_quality(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->shape_quality = NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_shape_quality(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return INT2NUM(p->parameters->shape_quality);
}
static VALUE
rb_parameters_set_coding(VALUE self,VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->coding = STR2CSTR(val);
  p->coding = val;
  return self;
}
static VALUE
rb_parameters_get_coding(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return rb_str_new2(p->parameters->coding);
}
static VALUE
rb_parameters_set_profile(VALUE self,VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->profile = STR2CSTR(val);
  p->profile = val;
  return self;
}
static VALUE
rb_parameters_get_profile(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return rb_str_new2(p->parameters->profile);
}
static VALUE
rb_parameters_set_verbose(VALUE self, VALUE val)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  p->parameters->verbose = (unsigned char) NUM2INT(val);
  return self;
}
static VALUE
rb_parameters_get_verbose(VALUE self)
{
  rb_parameters *p;
  Data_Get_Struct(self,rb_parameters,p);
  return CHR2FIX((char)p->parameters->verbose);
}
static VALUE
rb_object_get_name(VALUE self)
{
  rb_object *p;
  Data_Get_Struct(self,rb_object,p);
  return rb_str_new2(p->object->name);
}
static void
mark_yuv(void *p0)
{
  rb_yuv *p;

  p = (rb_yuv*)p0;
  if(p->y) rb_gc_mark(p->y);
  if(p->u) rb_gc_mark(p->u);
  if(p->v) rb_gc_mark(p->v);
}
static void
free_yuv(void *p0)
{
  rb_yuv *p;

  p = (rb_yuv*)p0;
  free(p->yuv);
  free(p);
}
static VALUE
rb_yuv_new(VALUE klass)
{
  rb_yuv *p;
  p = ALLOC(rb_yuv);
  p->yuv = ALLOC(fame_yuv_t);
  p->yuv->w = 0;
  p->yuv->h = 0;
  p->yuv->p = 0;
  p->yuv->y = NULL;
  p->yuv->u = NULL;
  p->yuv->v = NULL;
  p->y = 0;
  p->u = 0;
  p->v = 0;
  return Data_Wrap_Struct(klass,mark_yuv,free_yuv,p);
}
static void
mark_frame_statistics(void *p0)
{
  rb_frame_statistics *p;

  p = (rb_frame_statistics*)p0;
}
static void
free_frame_statistics(void *p0)
{
  rb_frame_statistics *p;

  p = (rb_frame_statistics*)p0;
  free(p->frame_statistics);
  free(p);
}
static void
mark_parameters(void *p0)
{
  rb_parameters *p;

  p = (rb_parameters*)p0;
  if(p->coding) rb_gc_mark(p->coding);
  if(p->profile) rb_gc_mark(p->profile);
}
static void
free_parameters(void *p0)
{
  rb_parameters *p;

  p = (rb_parameters*)p0;
  free(p->parameters);
  free(p);
}
static VALUE
rb_parameters_new(VALUE klass)
{
  rb_parameters *p;
  p = ALLOC(rb_parameters);
  p->parameters = ALLOC(fame_parameters_t);
  p->parameters->width = 352;
  p->parameters->height = 288;
  p->parameters->coding = "I";
  p->parameters->quality = 75;
  p->parameters->bitrate = 0;
  p->parameters->slices_per_frame = 1;
  p->parameters->frames_per_sequence = 0xffffffff;
  p->parameters->frame_rate_num = 25;
  p->parameters->frame_rate_den = 1;
  p->parameters->shape_quality = 100;
  p->parameters->search_range = 0;
  p->parameters->verbose = 1;
  p->parameters->profile = "mpeg4";
  p->parameters->total_frames = 0;
  p->parameters->retrieve_cb = NULL;
  p->coding = 0;
  p->profile = 0;
  return Data_Wrap_Struct(klass,mark_parameters,free_parameters,p);
};
static void
mark_object(void *p0)
{
  rb_object *p;

  p = (rb_object*)p0;
}
static void
free_object(void *p0)
{
  rb_object *p;

  p = (rb_object*)p0;
  free(p->object);
  free(p);
}
static VALUE
rb_yuv_from_rgb(VALUE self, VALUE str)
{
  rb_yuv *yuv;
  unsigned char *y, *u, *v;
  unsigned char *rgb;
  int w, h;
  long len;
  int i,j;
  int ii,jj;

  Data_Get_Struct(self,rb_yuv,yuv);
  w = yuv->yuv->w;
  h = yuv->yuv->h;

  rgb = rb_str2cstr(str, &len);
  if ( len!=w*h*3 )
    rb_raise(rb_eArgError,"rbg.length must be width * height * 3");

  len = w*h;

  y = ALLOC_N(unsigned char, len);
  u = ALLOC_N(unsigned char, len/4);
  v = ALLOC_N(unsigned char, len/4);

  for (i=0;i<len;i++)
    y[i] = 0.257*rgb[i*3] + 0.504*rgb[i*3+1] + 0.098*rgb[i*3+1] +16;
  for (j=0;j<h/2;j++)
    for (i=0;i<w/2;i++) {
      ii = i+j*w/2;
      jj = (i*2+j*2*w)*3;
      u[ii] = -0.148*rgb[jj] -0.291*rgb[jj+1] +0.439*rgb[jj+2] +128;
      jj = (i*2+(j*2+1)*w)*3;
      v[ii] = 0.439*rgb[jj] -0.368*rgb[jj+1] -0.071*rgb[jj+2] +128;
    }

  yuv->yuv->y = y;
  yuv->yuv->u = u;
  yuv->yuv->v = v;

  yuv->y = 0;
  yuv->u = 0;
  yuv->v = 0;

  return self;
}
static VALUE
rb_parameters_inspect(VALUE self)
{
  rb_parameters *rp;
  fame_parameters_t *p;

  Data_Get_Struct(self,rb_parameters,rp);
  p = rp->parameters;
  printf("width=%d, height=%d, coding=%s, quality=%d, bitrate=%d, slices_per_frame=%d, frames_per_sequence=%u, frame_rate_num=%d, frame_rate_den=%d, shape_quality=%d, search_range=%u, verbose=%u, profile=%s, total_frames=%u", p->width, p->height, p->coding, p->quality, p->bitrate, p->slices_per_frame, p->frames_per_sequence, p->frame_rate_num, p->frame_rate_den, p->shape_quality, p->search_range, p->verbose, p->profile, p->total_frames);
  return Qnil;
}
static VALUE
rb_frame_statistics_inspect(VALUE self)
{
  rb_frame_statistics *rp;
  fame_frame_statistics_t *p;

  Data_Get_Struct(self,rb_frame_statistics,rp);
  p = rp->frame_statistics;
  printf("frame_number=%u, coding=%c, target_bits=%d, actual_bits=%u, spatial_activity=%u, quant_scale=%f",p->frame_number, p->coding, p->target_bits, p->actual_bits, p->spatial_activity, p->quant_scale);
  return Qnil;
}
static void
mark_fame(void *p0)
{
  rb_fame *p;

  p = (rb_fame*)p0;
  rb_gc_mark(p->parameters);
}
static void
free_fame(void *p0)
{
  rb_fame *p;

  p = (rb_fame*)p0;
  if (p->flag) fame_close(p->context);
  if (p->buffer) free(p->buffer);
  free(p);
}
static VALUE
rb_fame_new(VALUE klass)
{
  rb_fame *p;
  fame_context_t *context;

  context = fame_open();
  if (!context)
    rb_raise(rb_eRuntimeError,"fame cannot open (fame_open)");
  p = ALLOC(rb_fame);
  p->context = context;
  p->flag = 1;
  return Data_Wrap_Struct(klass, mark_fame, free_fame, p);
}

static VALUE
rb_fame_init(VALUE self, VALUE params, VALUE rsize)
{
  rb_fame *p;
  rb_parameters *rparams;
  unsigned char *buffer;
  int size;

  if (CLASS_OF(params)!=cParameters)
    rb_raise(rb_eArgError,"argument must be LibFAME::Parameters");
  Data_Get_Struct(params,rb_parameters,rparams);
  size = NUM2INT(rsize);
  buffer = ALLOC_N(unsigned char,size);
  Data_Get_Struct(self,rb_fame,p);
  fame_init(p->context, rparams->parameters, buffer, size);
  p->parameters = params;
  p->buffer = buffer;
  return self;
}

static VALUE
rb_fame_register(VALUE self,VALUE type,VALUE object)
{
  rb_fame *p;
  rb_object *obj;
  ID id;

  id = rb_intern(STR2CSTR(type));
  if (CLASS_OF(object)!=cObject)
    rb_raise(rb_eArgError,"second argument must be LibFAME::Object");
  Data_Get_Struct(object,rb_object,obj);
  Data_Get_Struct(self,rb_fame,p);
  fame_register(p->context,rb_id2name(id),obj->object);
  return Qnil;
}

static VALUE
rb_fame_unregister(VALUE self,VALUE type)
{
  rb_fame *p;

  Data_Get_Struct(self,rb_fame,p);
  fame_unregister(p->context,STR2CSTR(type));
  return Qnil;
}

static VALUE
rb_fame_get_object(VALUE self,VALUE type)
{
  rb_fame *p;
  rb_object *obj;
  fame_object_t *cobj;
  ID id;

  id = rb_intern(STR2CSTR(type));
  cobj = ALLOC(fame_object_t);
  Data_Get_Struct(self,rb_fame,p);
  cobj = fame_get_object(p->context,rb_id2name(id));
  if (!cobj)
    rb_raise(rb_eRuntimeError,"%s is not found",rb_id2name(id));
  obj = ALLOC(rb_object);
  obj->object = cobj;
  return Data_Wrap_Struct(cObject,mark_object,free_object,obj);
}

static VALUE
rb_fame_start_frame(int argc, VALUE *argv, VALUE self)
{
  VALUE ryuv;
  VALUE rmask;
  rb_fame *p;
  rb_yuv *yuv;
  unsigned char *mask = NULL;

  rb_scan_args(argc, argv, "11", &ryuv, &rmask);
  if (argc==2)
    mask = STR2CSTR(rmask);

  if (CLASS_OF(ryuv)!=cYuv)
    rb_raise(rb_eArgError, "first argument must be LibFAME::Yuv");
  Data_Get_Struct(ryuv,rb_yuv,yuv);

  Data_Get_Struct(self,rb_fame,p);
  fame_start_frame(p->context,yuv->yuv,mask);
  return Qnil;
}

static VALUE
rb_fame_encode_slice(VALUE self)
{
  rb_fame *p;
  int len;

  Data_Get_Struct(self,rb_fame,p);
  len = fame_encode_slice(p->context);
  return rb_str_new(p->buffer,len);
}
  
static VALUE
rb_fame_end_frame(VALUE self)
{
  rb_fame *p;
  rb_frame_statistics *rstat;
  fame_frame_statistics_t *stat;

  Data_Get_Struct(self,rb_fame,p);
  stat = ALLOC(fame_frame_statistics_t);
  fame_end_frame(p->context,stat);
  rstat = ALLOC(rb_frame_statistics);
  rstat->frame_statistics = stat;
  return Data_Wrap_Struct(cFrame_statistics,mark_frame_statistics,free_frame_statistics,rstat);
}

static VALUE
rb_fame_encode_frame(int argc, VALUE *argv, VALUE self)
{
  VALUE ryuv;
  VALUE rmask;
  rb_fame *p;
  rb_yuv *yuv;
  unsigned char *mask = NULL;
  int len;

  rb_scan_args(argc, argv, "11", &ryuv, &rmask);
  if (argc==2)
    mask = STR2CSTR(rmask);

  if (CLASS_OF(ryuv)!=cYuv)
    rb_raise(rb_eArgError, "first argument must be LibFAME::Yuv");
  Data_Get_Struct(ryuv,rb_yuv,yuv);

  Data_Get_Struct(self,rb_fame,p);
  len = fame_encode_frame(p->context,yuv->yuv,mask);
  return rb_str_new(p->buffer,len);
}

static VALUE
rb_fame_close(VALUE self)
{
  rb_fame *p;
  int len;

  Data_Get_Struct(self,rb_fame,p);
  len = fame_close(p->context);
  p->flag = 0;
  return INT2NUM(len);
}


void Init_libfame()
{
  mLibFAME = rb_define_module("LibFAME");
  rb_define_const(mLibFAME,"Version",rb_ary_new3(3,INT2NUM(LIBFAME_MAJOR_VERSION),INT2NUM(LIBFAME_MINOR_VERSION),INT2NUM(LIBFAME_MICRO_VERSION)));

  cYuv = rb_define_class_under(mLibFAME, "Yuv", rb_cObject);
  rb_define_singleton_method(cYuv,"new",rb_yuv_new,0);

  cFrame_statistics = rb_define_class_under(mLibFAME, "Frame_statistics", rb_cObject);

  cParameters = rb_define_class_under(mLibFAME, "Parameters", rb_cObject);
  rb_define_singleton_method(cParameters,"new",rb_parameters_new,0);

  cObject = rb_define_class_under(mLibFAME, "Object", rb_cObject);

  cFame = rb_define_class_under(mLibFAME, "Fame", rb_cObject);
  rb_define_singleton_method(cFame,"new",rb_fame_new,0);
  rb_define_singleton_method(cFame,"open",rb_fame_new,0);


  rb_define_method(cYuv,"set_w",rb_yuv_set_w,1);
  rb_define_alias(cYuv,"w=","set_w");
  rb_define_method(cYuv,"get_w",rb_yuv_get_w,0);
  rb_define_alias(cYuv,"w","get_w");
  rb_define_method(cYuv,"set_h",rb_yuv_set_h,1);
  rb_define_alias(cYuv,"h=","set_h");
  rb_define_method(cYuv,"get_h",rb_yuv_get_h,0);
  rb_define_alias(cYuv,"h","get_h");
  rb_define_method(cYuv,"set_p",rb_yuv_set_p,1);
  rb_define_alias(cYuv,"p=","set_p");
  rb_define_method(cYuv,"get_p",rb_yuv_get_p,0);
  rb_define_alias(cYuv,"p","get_p");
  rb_define_method(cYuv,"set_y",rb_yuv_set_y,1);
  rb_define_alias(cYuv,"y=","set_y");
  rb_define_method(cYuv,"set_u",rb_yuv_set_u,1);
  rb_define_alias(cYuv,"u=","set_u");
  rb_define_method(cYuv,"set_v",rb_yuv_set_v,1);
  rb_define_alias(cYuv,"v=","set_v");
  rb_define_method(cYuv,"from_rgb",rb_yuv_from_rgb,1);
  rb_define_method(cFrame_statistics,"get_frame_number",rb_frame_statistics_get_frame_number,1);
  rb_define_alias(cFrame_statistics,"frame_number","get_frame_number");
  rb_define_method(cFrame_statistics,"get_coding",rb_frame_statistics_get_coding,1);
  rb_define_alias(cFrame_statistics,"coding","get_coding");
  rb_define_method(cFrame_statistics,"get_target_bits",rb_frame_statistics_get_target_bits,1);
  rb_define_alias(cFrame_statistics,"target_bits","get_target_bits");
  rb_define_method(cFrame_statistics,"get_actual_bits",rb_frame_statistics_get_actual_bits,1);
  rb_define_alias(cFrame_statistics,"actual_bits","get_actual_bits");
  rb_define_method(cFrame_statistics,"get_spatial_activity",rb_frame_statistics_get_spatial_activity,1);
  rb_define_alias(cFrame_statistics,"spatial_activity","get_spatial_activity");
  rb_define_method(cFrame_statistics,"get_quant_scale",rb_frame_statistics_get_quant_scale,1);
  rb_define_alias(cFrame_statistics,"quant_scale","get_quant_scale");
  rb_define_method(cFrame_statistics,"inspect",rb_frame_statistics_inspect,0);
  rb_define_method(cParameters,"set_width",rb_parameters_set_width,1);
  rb_define_alias(cParameters,"width=","set_width");
  rb_define_method(cParameters,"get_width",rb_parameters_get_width,0);  rb_define_alias(cParameters,"width","get_width");
  rb_define_method(cParameters,"set_height",rb_parameters_set_height,1);
  rb_define_alias(cParameters,"height=","set_height");
  rb_define_method(cParameters,"get_height",rb_parameters_get_height,0);  rb_define_alias(cParameters,"height","get_height");
  rb_define_method(cParameters,"set_coding",rb_parameters_set_coding,1);
  rb_define_alias(cParameters,"coding=","set_coding");
  rb_define_method(cParameters,"get_coding",rb_parameters_get_coding,0);  rb_define_alias(cParameters,"coding","get_coding");
  rb_define_method(cParameters,"set_quality",rb_parameters_set_quality,1);
  rb_define_alias(cParameters,"quality=","set_quality");
  rb_define_method(cParameters,"get_quality",rb_parameters_get_quality,0);  rb_define_alias(cParameters,"quality","get_quality");
  rb_define_method(cParameters,"set_bitrate",rb_parameters_set_bitrate,1);
  rb_define_alias(cParameters,"bitrate=","set_bitrate");
  rb_define_method(cParameters,"get_bitrate",rb_parameters_get_bitrate,0);  rb_define_alias(cParameters,"bitrate","get_bitrate");
  rb_define_method(cParameters,"set_slices_per_frame",rb_parameters_set_slices_per_frame,1);
  rb_define_alias(cParameters,"slices_per_frame=","set_slices_per_frame");
  rb_define_method(cParameters,"get_slices_per_frame",rb_parameters_get_slices_per_frame,0);  rb_define_alias(cParameters,"slices_per_frame","get_slices_per_frame");
  rb_define_method(cParameters,"set_frames_per_sequence",rb_parameters_set_frames_per_sequence,1);
  rb_define_alias(cParameters,"frames_per_sequence=","set_frames_per_sequence");
  rb_define_method(cParameters,"get_frames_per_sequence",rb_parameters_get_frames_per_sequence,0);  rb_define_alias(cParameters,"frames_per_sequence","get_frames_per_sequence");
  rb_define_method(cParameters,"set_frame_rate_num",rb_parameters_set_frame_rate_num,1);
  rb_define_alias(cParameters,"frame_rate_num=","set_frame_rate_num");
  rb_define_method(cParameters,"get_frame_rate_num",rb_parameters_get_frame_rate_num,0);  rb_define_alias(cParameters,"frame_rate_num","get_frame_rate_num");
  rb_define_method(cParameters,"set_frame_rate_den",rb_parameters_set_frame_rate_den,1);
  rb_define_alias(cParameters,"frame_rate_den=","set_frame_rate_den");
  rb_define_method(cParameters,"get_frame_rate_den",rb_parameters_get_frame_rate_den,0);  rb_define_alias(cParameters,"frame_rate_den","get_frame_rate_den");
  rb_define_method(cParameters,"set_shape_quality",rb_parameters_set_shape_quality,1);
  rb_define_alias(cParameters,"shape_quality=","set_shape_quality");
  rb_define_method(cParameters,"get_shape_quality",rb_parameters_get_shape_quality,0);  rb_define_alias(cParameters,"shape_quality","get_shape_quality");
  rb_define_method(cParameters,"set_search_range",rb_parameters_set_search_range,1);
  rb_define_alias(cParameters,"search_range=","set_search_range");
  rb_define_method(cParameters,"get_search_range",rb_parameters_get_search_range,0);  rb_define_alias(cParameters,"search_range","get_search_range");
  rb_define_method(cParameters,"set_verbose",rb_parameters_set_verbose,1);
  rb_define_alias(cParameters,"verbose=","set_verbose");
  rb_define_method(cParameters,"get_verbose",rb_parameters_get_verbose,0);  rb_define_alias(cParameters,"verbose","get_verbose");
  rb_define_method(cParameters,"set_profile",rb_parameters_set_profile,1);
  rb_define_alias(cParameters,"profile=","set_profile");
  rb_define_method(cParameters,"get_profile",rb_parameters_get_profile,0);  rb_define_alias(cParameters,"profile","get_profile");
  rb_define_method(cParameters,"set_total_frames",rb_parameters_set_total_frames,1);
  rb_define_alias(cParameters,"total_frames=","set_total_frames");
  rb_define_method(cParameters,"get_total_frames",rb_parameters_get_total_frames,0);  rb_define_alias(cParameters,"total_frames","get_total_frames");
  rb_define_method(cParameters,"inspect",rb_parameters_inspect,0);
  rb_define_method(cObject,"get_name",rb_object_get_name,0);
  rb_define_alias(cObject,"name","get_name");
  rb_define_method(cFame,"init",rb_fame_init,2);
  rb_define_method(cFame,"register",rb_fame_register,2);
  rb_define_method(cFame,"unregister",rb_fame_unregister,1);
  rb_define_method(cFame,"get_object",rb_fame_get_object,1);
  rb_define_method(cFame,"start_frame",rb_fame_start_frame,-1);
  rb_define_method(cFame,"encode_slice",rb_fame_encode_slice,0);
  rb_define_method(cFame,"end_frame",rb_fame_end_frame,0);
  rb_define_method(cFame,"encode_frame",rb_fame_encode_frame,-1);
  rb_define_method(cFame,"close",rb_fame_close,0);
}
