require "rubygems" unless defined?(Gem)

require "mkmf"
require "rbconfig"
so = RbConfig::CONFIG["DLEXT"]

#if Gem.respond_to?(:find_files) and Gem.find_files("numru/narray/narray.h").length > 0
#  narray_include = File.expand_path(File.dirname(Gem.find_files("numru/narray/narray.h")[0]))
#  narray_lib = File.expand_path(File.dirname(Gem.find_files("numru/narray/narray." + so)[0]))
#elsif Gem.respond_to?(:find_files) and Gem.find_files("narray.h").length > 0

if Gem.respond_to?(:find_files) and Gem.find_files("narray.h").length > 0
  narray_include = File.expand_path(File.dirname(Gem.find_files("narray.h")[0]))
  narray_lib = File.expand_path(File.dirname(Gem.find_files("narray." + so)[0]))
else
  gem_home=(`gem environment GEM_HOME`).chomp
  narray_dir = Dir.glob("#{gem_home}/gems/narray-*/ext/narray").sort[-1]
  if narray_dir
    narray_include = narray_lib = narray_dir
  else
    narray_include = narray_lib = [ $sitearchdir, $vendorarchdir]
  end
end
dir_config('narray', narray_include, narray_lib)
if ( ! ( have_header("narray.h") && have_header("narray_config.h") ) ) then
   print <<-EOS
   ** configure error **  
   Header narray.h or narray_config.h is not found. If you have these files in 
   /narraydir/include, try the following:

   % ruby extconf.rb --with-narray-include=/narraydir/include

   EOS
   exit(-1)
end

initcfile_default = $srcdir+"/init.c.default"
initcfile = $srcdir+"/init.c"

if(xsystem("which cdclconfig"))
  cflags = `cdclconfig --cflags`.gsub(/\n/, " ")
  ldflags = `cdclconfig --ldflags`.gsub(/\n/, " ")
  ldlibs = `cdclconfig --ldlibs`.gsub(/-R.*?\s/, " ").gsub(/\n/, " ")
  print "checking DCL version... "
  dclversion = `cdclconfig --dclversion`.strip
  print "DCL Version: #{dclversion}\n"
  dclver = dclversion.gsub(/\./,'')
  dclver = dclver+'0' if dclver.length <= 2   # 53 --> 530 etc
  if dclversion < "5.2"
    raise "Supported DCL version is 5.2 or later, while you have #{dclversion}"
  end
  dclversionmacro = ' -DDCLVER='+dclver

  $CFLAGS += ' '+cflags  + dclversionmacro
  $LOCAL_LIBS += ' ' + ldflags
  $LOCAL_LIBS += ldlibs

  fin = File.open(initcfile_default)
  fout = File.open(initcfile,'w')
  while(line = fin.gets)
    fout.puts(line.sub(/DCLVersion/,'"'+dclversion+'"'))
  end
  fout.close
  fin.close

else
  raise "cdclconfig is not found."
end

create_makefile("numru/dcl_raw")
