#
# u2d7.rb
#   $Id$
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nx = 21
ny = 21
xmin = -10
xmax = 10
ymin = -10
ymax = 10
dx1 = 1
dx2 = 5
dy1 = 1
dy2 = 5
kmax = 5
pmin = 0
pmax = 1
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)
p = NArray.sfloat(nx, ny)
pi = NArray.sfloat(2, kmax+1)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    x = xmin + (xmax-xmin)*i/(nx-1).to_f
    y = ymin + (ymax-ymin)*j/(ny-1).to_f
    u[i,j] =  x
    v[i,j] = -y
    p[i,j] = exp(-x**2/64 -y**2/25)
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::sglset('LSOFTF', true)
DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::uxaxdv('B', dx1, dx2)
DCL::uxaxdv('T', dx1, dx2)
DCL::uxsttl('B', 'X-axis', 0.0)
DCL::uxmttl('T', 'FIGURE TITLE', 0.0)

DCL::uyaxdv('L', dy1, dy2)
DCL::uyaxdv('R', dy1, dy2)
DCL::uysttl('L', 'Y-axis', 0.0)

DCL::uglset('LUNIT', true)
DCL::ugrset('VXUOFF', 0.04)
DCL::ugsut('X', 'U')
DCL::ugsut('Y', 'V')
DCL::ugvect(u, v)

DCL::udlset('LABEL', false)
DCL::udlset('LMSG', false)
DCL::udgclb(p, 0.1)
DCL::udcntr(p)

dp = (pmax-pmin)/kmax.to_f
for k in 1..kmax
  tlev1 = (k-1)*dp
  tlev2 = tlev1 + dp
  ipat  = 600 + k - 1
  DCL::uestlv(tlev1, tlev2, ipat)
end
DCL::uetone(p)

#-- ȡС ----
DCL::grswnd(0.0, 1.0, pmin, pmax)
DCL::grsvpt(0.85, 0.9, 0.45, 0.75)
DCL::grstrn(1)
DCL::grstrf

for k in 1..kmax+1
  pi[0,k-1] = pmin + (k-1)*dp
  pi[1,k-1] = pmin + (k-1)*dp
end

DCL::udcntr(pi)
DCL::uetone(pi)

DCL::slpvpr(3)
DCL::uzlset('LABELYR', true)
DCL::uzfact(0.8)
DCL::uysfmt('(F4.1)')
DCL::uyaxdv('R', dp, dp)

DCL::grcls
