#
# u2d4.rb
#   $Id$
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nx = 37
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = 90
drad = PI / 180
kxmn = 9
kxmx = 33
kymn = 7
kymx = 31

p = NArray.sfloat(nx, ny)
alon = NArray.sfloat(nx)
alat = NArray.sfloat(ny)

#-- data ---
for i in 0..nx-1
  alon[i] = xmin + (xmax-xmin)*i/(nx-1).to_f
end
for j in 0..ny-1
  alat[j] = ymin + (ymax-ymin)*j/(ny-1).to_f
end

for j in 0..ny-1
  slat = sin(alat[j]*drad)
  for i in 0..nx-1
    p[i,j] = 3*sqrt(1-slat**2)*slat*cos(alon[i]*drad) - 0.5*(3*slat**2-1)
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(alon[kxmn-1], alon[kxmx-1], alat[kymn-1], alat[kymx-1])
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::usdaxs
DCL::udcntr(p[(kxmn-1)..(kxmx-1), (kymn-1)..(kymx-1)])

DCL::grcls

