#
# quick5.rb
#   $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nx = 21
ny = 21
xmin = -1.0
xmax = 1.0
ymin = -1.0
ymax = 1.0

u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)

#-- data ----
for j in 0..ny-1
  for i in 0..nx-1
    x = xmin + (xmax-xmin)*i/(nx-1)
    y = ymin + (ymax-ymin)*j/(ny-1)
    u[i,j] = x
    v[i,j] = -y
  end
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::usdaxs
DCL::ugvect(u, v)

DCL::grcls

