#
# miss1.rb
#   $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include NMath


nmax = 40
xmin = 0.0
xmax = 4*PI
ymin = -1.0
ymax = 1.0

x = NArray.sfloat(nmax+1)
y = NArray.sfloat(nmax+1)

#-- data ----
dt = xmax/nmax
x = x.indgen * dt
y = sin(x)

n1 = nmax/4
rmiss = DCL::glrget('RMISS')
y[n1-1] = rmiss
y[n1]   = rmiss
y[n1+1] = rmiss

n2 = n1*3
y[n2-1] = rmiss
y[n2+1] = rmiss

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws
DCL::grfrm

#-- default ----
DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt( 0.1,  0.9,  0.7,  0.9)
DCL::grstrn(1)
DCL::grstrf

DCL::sgplu(x, y)

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt( 0.1,  0.9,  0.5,  0.7)
DCL::grstrn(1)
DCL::grstrf

DCL::sgspmt(3)
DCL::sgpmu(x, y)

#-- cover loss data ----
DCL::gllset('LMISS', true)

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt( 0.1,  0.9,  0.3,  0.5)
DCL::grstrn(1)
DCL::grstrf

DCL::sgplu(x, y)

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt( 0.1,  0.9,  0.1,  0.3)
DCL::grstrn(1)
DCL::grstrf

DCL::sgpmu(x, y)

DCL::grcls

