#
# uspk10.rb
#
# $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include NMath


n = 400
x = NArray.sfloat(n)
y = NArray.sfloat(n)

#-----------------------------------------------------------------------
dt = 2*PI/(n-1)
x = x.indgen * dt
y = y.indgen * 2*dt
y = sin(y) * 10.0

#---------------------------- 1ST PAGE ---------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::usgrph(x, y)

#---------------------------- 2ND PAGE ---------------------------------
rundef = DCL::glrget('RUNDEF')

DCL::grfrm
DCL::grswnd(0.0, 2.0*PI, rundef, rundef)

DCL::usrset('DXL', 1.25)
DCL::usrset('DXT', 0.25)

DCL::usrset('XFAC', 0.1)
DCL::usrset('YFAC', 10.0)

DCL::usgrph(x, y)

#-----------------------------------------------------------------------

DCL::grcls

