#
# uspk05.rb
#
# $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 200
m = 5
x = NArray.sfloat(n)
y0 = NArray.sfloat(n)
y1 = NArray.sfloat(n)
y2 = NArray.sfloat(n)
a = NArray.sfloat(m)

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

x = x.indgen * dt
for i in 0..n-1
  t = dt*i*2*PI
  y2[i] = 0.0
  for j in 0..m-1
    jj = j*2+1
    yy = a[j]*cos(jj*t)
    y2[i] = y2[i] + yy
  end
  y1[i] = a[0]*cos(t)

  if (t < PI/2.0 || t >= PI*3.0/2.0)
    y0[i] = -0.5
  else
    y0[i] = 0.5
  end
end

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL::gropn iws

DCL::grfrm

DCL::usspnt(x, y0)
DCL::usspnt(x, y1)
DCL::usspnt(x, y2)

DCL::uspfit
DCL::grstrf

DCL::usdaxs

DCL::uulinz(x, y0, 1, 5)
DCL::uulinz(x, y1, 3, 1)
DCL::uulinz(x, y2, 2, 2)

DCL::grcls

