#
# test05.rb
#
# $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include Math


np = 14
nx = 73
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = 90
p = NArray.new(Float, nx*ny)

#-- data ---
ctr = ['cyl','mer','mwd','hmr','ek6','ktd','con',
       'coa','coc','bon','otg','pst','azm','aza']
fct = NArray[0.12, 0.12, 0.14, 0.14, 0.14, 0.14, 0.11,
               0.16, 0.12, 0.12, 0.40, 0.12, 0.12, 0.17]

i = 0
File.foreach('t811231.dat') do |line|
  line.split(" ").each do |data|
    p[i] = data.to_f
    i += 1
  end
end
p.reshape!(nx, ny)

190.step(245, 5) do |r|
  amin=r
  amax=r+5
#       IDX=(R-180)*1.4*1000+999
  idx=((r-170)*1.25).to_i*1000+999
  DCL::uestlv(amin, amax, idx)
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sglset('LSOFTF', false)
DCL::sgrset('STLAT1', 75.0)
DCL::sgrset('STLAT2', 60.0)
DCL::umlset('LGRIDMJ', false)
DCL::umrset('DGRIDMN', 30.0)

for i in 0..np-1
  DCL::sgfrm
  DCL::sgssim(fct[i], 0.0, 0.0)
  DCL::sgsmpl(165.0, 60.0, 0.0)
  DCL::sgsvpt(0.1, 0.9, 0.1, 0.9)
  DCL::sgswnd(xmin, xmax, ymin, ymax)

  if (ctr[i] == 'otg')
    DCL::sgstxy(-180.0, 180.0, 0.0, 90.0)
  else
    DCL::sgstxy(-180.0, 180.0, -90.0, 90.0)
  end
  DCL::sgstrn(DCL::isgtrc(ctr[i]))
  DCL::sgstrf

  DCL::sglset('LCLIP', true)
  DCL::slpwwr(1)
  DCL::slpvpr(1)
  cttl = DCL::sgtrnl(DCL::isgtrc(ctr[i]))
  DCL::sgtxzr(0.5, 0.95, cttl, 0.03, 0, 0, 3)

  DCL::uetone(p)
  DCL::udcntr(p)
  DCL::umpmap('coast_world')
  DCL::umpglb
  DCL::slpvpr(1)
end

DCL::sgcls

