#
# test04.rb
#
# $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include Math


np = 14

#-- data ---
ctr = ['cyl','mer','mwd','hmr','ek6','ktd','con',
       'coa','coc','bon','otg','pst','azm','aza']
fct = NArray[0.12, 0.12, 0.14, 0.14, 0.14, 0.14, 0.11,
               0.16, 0.12, 0.12, 0.40, 0.12, 0.12, 0.17]

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sgrset('STLAT1', 45.0)
DCL::sgrset('STLAT2', 30.0)

for i in 0..np-1
  DCL::sgfrm
  DCL::sgssim(fct[i], 0.0, 0.0)
  DCL::sgsmpl(0.0, 90.0, 0.0)
  DCL::sgsvpt(0.1, 0.9, 0.1, 0.9)

  if (ctr[i] == 'otg')
    DCL::sgstxy(-180.0, 180.0, 0.0, 90.0)
  else
    DCL::sgstxy(-180.0, 180.0, -90.0, 90.0)
  end
  DCL::sgstrn(DCL::isgtrc(ctr[i]))
  DCL::sgstrf

  DCL::sglset('LCLIP', true)
  DCL::slpwwr(1)
  DCL::slpvpr(1)
  cttl = DCL::sgtrnl(DCL::isgtrc(ctr[i]))
  DCL::sgtxzr(0.5, 0.95, cttl, 0.03, 0, 0, 3)

  DCL::umpmap('coast_world')
  DCL::umpglb
end

DCL::sgcls

