#
# scpkt7.rb
#
# $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nx = 37
xmin = 0.0
xmax = 360.0
ymin = -1.0
ymax = 1.0
drad = PI/180

alon = NArray.sfloat(nx)
alat = NArray.sfloat(nx)
r = NArray.sfloat(nx)
a = NArray.sfloat(nx)

#-- data ---
alon.indgen(xmin, (xmax-xmin)/(nx-1).to_f)
alat = alat.indgen * (  (ymax-ymin)/(nx-1).to_f ) + ymin
r.fill!(1.0)

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL::sgopn iws

DCL::sgfrm
DCL::sglset('LDEG', true)

#---------------- 3-D ------------------
DCL::scsorg(1.0, 0.0, 0.0, 0.0)
DCL::scstrn(2)
DCL::scstrf

DCL::scseye(5.0, 1.0, 2.0)
DCL::scsobj(0.0, 0.0, 0.0)
DCL::scsprj

for i in 0..nx-1
  a.fill!(alat[i])
  DCL::scplu(r, alon, a)
end

for i in 0..nx-1
  a.fill(alon[i])
  DCL::scplu(r, a, alat)
end

DCL::sgcls

