#
# u2d4.rb
#   $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include NMath

nx = 21
ny = 21
xmin = -10.0
xmax = 10.0
ymin = -10.0
ymax = 10.0
kmax = 5
pmin = 0.0
pmax = 1.0
dx = (xmax-xmin)/(nx-1)
dy = (ymax-ymin)/(ny-1)
dp = (pmax-pmin)/kmax

u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)
p = NArray.sfloat(nx, ny)


#-- data ----
xi = xmin + NArray.sfloat(nx).indgen! * dx
yj = ymin + NArray.sfloat(ny).indgen! * dy
for j in 0..ny-1; u[true,j] = xi; end
for i in 0..nx-1; v[i,true] = -yj; end
p = exp(-xi.reshape(nx,1)**2/64 - yj.reshape(1,ny)**2/25)

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::sglset('LSOFTF', true)
DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::uspfit
DCL::grstrf

DCL::usdaxs
DCL::ugvect(u, v)
DCL::udcntr(p)

for k in 0..kmax-1
  tlev1 = k*dp
  tlev2 = tlev1 + dp
  ipat  = 600 + k
  DCL::uestlv(tlev1, tlev2, ipat)
end

DCL::uetone(p)

DCL::grcls

