#
# u2d3.rb
#   $Id$
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nx = 21
ny = 21
xmin = -1.0
xmax = 1.0
ymin = -1.0
ymax = 1.0
dx = (xmax-xmin)/(nx-1)
dy = (ymax-ymin)/(ny-1)

u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)

#-- data ----
xi = xmin + NArray.sfloat(nx).indgen! * dx
yj = ymin + NArray.sfloat(ny).indgen! * dy
for j in 0..ny-1; u[true,j] = xi; end
for i in 0..nx-1; v[i,true] = -yj; end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::uspfit
DCL::grstrf

DCL::ussttl('X', 'km', 'Y', 'km')
DCL::usdaxs

DCL::ugvect(u, v)

DCL::grcls

