require "narray"
require "numru/dcl"
include NumRu

# set wave number
nx = 101; ny =51
mm = 50; jm = 25; im = 50
work =  DCL.shtint(mm, jm, im)

# make test data
x = NMath::sin(2*NMath::PI*NArray.float(nx).indgen!/(nx-1))
ln = x.shape[0]-1; x[-1, false] = x[0,false]
xx = x.newdim(1)
y = NArray.float(ny).fill!(1.0)
yy = y.newdim(0)
zz = xx*yy


wz, sz = DCL.shtg2s(mm, jm, im, 0, zz, work) # grid => spectle
wz, gz = DCL.shts2g(mm, jm, im, 0, sz, work) # grid => spectle

p zz.shape  # before
p gz.shape  # after
