module NumRu
   class Attribute < Hash 
      class << Attribute
	 alias _set_ []

	 def [](*keyval)
	    keyval.each_index{|i|
	       if(i % 2 ==0)
		  unless(keyval[i].is_a?(Symbol))
		     keyval[i] = keyval[i].intern
		  end
	       end
	    }
	    Attribute._set_(*keyval)
	 end
      end

      alias _clone_ clone

      def clone
	 new_attr = NumRu::Attribute.new
	 self.each{|key, val|
	    if(val)
	       new_attr[key] = val.clone
	    else
	       new_attr[key] = val
	    end
	 }
	 new_attr
      end

      alias _get_ []

      def [](key)
	 if(key.is_a?(Symbol))
	    self._get_(key)
	 elsif(key.is_a?(String))
	    symbol = key.intern
	    self._get_(symbol)
	 else
	    raise ArgumentError, "In Attribute class, expects Symbol or String for key." 
	 end
      end

      alias _set_ []=

      def []=(key, val)
	 if(key.is_a?(Symbol))
	    self._set_(key, val)
	 elsif(key.is_a?(String))
	    symbol = key.intern
	    self._set_(symbol, val)
	 else
	    raise ArgumentError, "In Attribute class, expects Symbol or String for key." 
	 end
      end
   end
end

if __FILE__ == $0
   a = NumRu::Attribute.new
   a["name"]="kawanabe"
   p a["name"]
   p a
   b = @attr = NumRu::Attribute[:name,"var", :units,"1", :valid_range,nil]
   p b[:units]
   p b["units"]
   p b
end
