require "rbconfig"
require "ftools"
include Config

package = "gave"

bindir = "/usr/local/bin"
sitelibdir = CONFIG["sitelibdir"]+"/numru"
subdir = sitelibdir+"/"+package
localedir = "/usr/share/locale/"

bin_file = [package]
sub_files = %w(draw.rb)
locale = %w(ja)


File.makedirs(bindir)
bin_file.each{|f|
  File.install(f,bindir)
}

File.makedirs(subdir)
sub_files.each{|f|
  File.install(f,subdir)
}

locale.each{|l|
  message_dir = "#{localedir}#{l}/LC_MESSAGES/"
  File.makedirs(localedir)
  File.install("po/#{l}.mo","#{message_dir}#{package}.mo")
}


