=begin header
  draw.rb - a part of gdcl.rb
=end

require "gdk_imlib"
require "narray"
require "numru/dcl"

include NumRu

class VArray
  def mapping
    @mapping
  end
end

class Draw_data
  attr_accessor :filename
  attr_accessor :gphys
  attr_accessor :funcs
  attr_accessor :cont, :tone
  attr_accessor :transpose
  attr_accessor :type, :map_type
  attr_accessor :title
  attr_reader :axis_x, :axis_y
  def initialize
    @axis_x = Axis.new
    @axis_y = Axis.new
    @funcs = Array.new
    clear
  end
  def clear_var
    @gphys = nil
    @transpose = false
    @axis_x.clear
    @axis_y.clear
    @funcs = Array.new
  end
  def clear
    clear_var
    @title = nil
    @type = LINE
    @map_type = nil
  end
  class Axis
    attr_accessor :min, :max
    attr_accessor :title, :unit
    attr_accessor :log
    def initialize
      clear
    end
    def clear
      @title=""
      @unit=""
      @log=false
    end
  end
end


class Mouse_Events
  MOVE = 1
  RESIZE = 2
  attr_writer :height, :width
  def initialize(height,width)
    @height=height
    @width=width
  end
  def length; @height<@width ? @height : @width; end
  def xoffset; (@width-length)/2; end
  def yoffset; (@height-length)/2; end
  def pressed(px,py,l,r,b,t)
    @move = false
    @left,@right,@bottom,@top, = l,r,b,t
    @axis = where(px,py,l,r,b,t)
    if @axis then
      if @axis==4 then
	@move=MOVE
	@bpx,@bpy, = px,py
	p "begin move"
      else
	@move=RESIZE
	p "begin resize"
      end
    else
      @move = false
    end
  end
  def released(px,py)
    print "released:",px,",",py,"\n"
    if @move==MOVE then
      @move=false
      p "end move"
      dx=px-@bpx
      dy=py-@bpy
      [@left+dx,@right+dx,@bottom+dy,@top+dy]
    elsif @move==RESIZE then
      @move=false
      p "end resize"
      l,r,b,t, = @left,@right,@bottom,@top
      @left=nil;@right=nil;@bottom=nil;@top=nil
      @bpx=nil;@bpy=nil
      set(px,py,l,r,b,t)
    end
  end
  def draged(w,px,py)
    if @move==MOVE then
      gc = w.style.fg_gc(w.state)
      x = (@left+px-@bpx)*length+xoffset
      y = (1-@top-py+@bpy)*length+yoffset
      xl = length*(@right-@left)
      yl = length*(@top-@bottom)
      w.window.draw_rectangle(gc, false, x, y, xl, yl)
    elsif @move==RESIZE then
      l,r,b,t, = set(px,py,@left,@right,@bottom,@top)
      gc = w.style.fg_gc(w.state)
      x = l*length+xoffset
      y = (1-t)*length+yoffset
      xl = length*(r-l)
      yl = length*(t-b)
      w.window.draw_rectangle(gc, false, x, y, xl, yl)
    end
  end
  def where(px,py,l,r,b,t)
    width = 0.01
    if (px>l-width)&&(px<r+width)&&(py>b-width)&&(py<t+width) then
      if (px-l).abs < width then 0
      elsif (px-r).abs < width then 1
      elsif (py-b).abs < width then 2
      elsif (py-t).abs < width then 3
      else 4
      end
    else
      false
    end
  end
  def move?
    @move
  end
  def set(px,py,l,r,b,t)
    diff=0.05
    lo,ro,bo,to, = [l,r,b,t]
    if @axis==0 then
      if px<diff then
	lo=diff
      elsif px>(r-diff) then
	lo=r-diff
      else
	lo=px
      end
    elsif @axis==1 then
      if px>(1-diff) then
	ro=1-diff
      elsif px<(l+diff) then
	ro=l+diff
      else
	ro=px
      end
    elsif @axis==2 then
      if py<diff then
	bo=diff
      elsif py>(t-diff) then
	bo=t-diff
      else
	bo=py
      end
    elsif @axis==3 then
      if py>(1-diff) then
	to=1-diff
      elsif py<(b+diff) then
	to=b+diff
      else
	to=py
      end
    end
    [lo,ro,bo,to]
  end
end


class Draw
  def initialize
    @pixmap = nil
    @height=400
    @width=400
    @rect = Array.new(4)
    clear
  end
  def clear
    @type = nil
    @title = nil
    @vxmin=0.2; @vxmax=0.8
    @vymin=0.2; @vymax=0.8
    @miss=nil
    @x_title=""; @x_unit=""
    @y_title=""; @y_unit=""
    @fig = Fig.new
    @frame = Mouse_Events.new(@height,@width)
    @opened = false
  end
  def draw_x(draw_data)
    @filename = draw_data.filename
    @varname = draw_data.gphys.name
    @funcs = draw_data.funcs
    @xmin = draw_data.axis_x.min
    @xmax = draw_data.axis_x.max
    @ymin = draw_data.axis_y.min
    @ymax = draw_data.axis_y.max
    @gphys = draw_data.gphys
    @mapping = draw_data.gphys.data.mapping.slicer
#    @miss = draw_data.var.missing_value
    @title = draw_data.title
    @transpose = draw_data.transpose
    @logx = draw_data.axis_x.log
    @logy = draw_data.axis_y.log
    @x_title = draw_data.axis_x.title
    @x_unit = draw_data.axis_x.unit
    @y_title = draw_data.axis_y.title
    @y_unit = draw_data.axis_y.unit
    @type = draw_data.type
    @maptype = draw_data.map_type
    @cont = draw_data.cont
    @tone = draw_data.tone
    @fig.var_set(@filename,@varname,@funcs,@mapping)
    @fig.title_set(@x_title,@x_unit,@y_title,@y_unit)
    if @window.nil?
      open_graphics
    else
      draw(@draw_area)
    end
    @window.show
  end
  def open_graphics
    set_env
    @draw_area = Gtk::DrawingArea.new
    @draw_area.size(@width,@height)
    @draw_area.signal_connect("expose_event"){|w,p| expose_event(w,p) }
    @draw_area.signal_connect("configure_event"){|w,p|
      configure_event(w)
      @width =  w.allocation.width; @frame.width=@width
      @height = w.allocation.height; @frame.height=@height
    }
    @draw_area.signal_connect("button_press_event"){|w,p|
      if p.button==1 then
	px = (p.x-@frame.xoffset)/@frame.length
	py = 1 - (p.y-@frame.yoffset)/@frame.length
	print "press:",px,",",py,"\n"
	@frame.pressed(px,py,@vxmin,@vxmax,@vymin,@vymax)
      else
	w.get_toplevel.hide
      end
    }
    @draw_area.signal_connect("button_release_event"){|w,p|
      px = (p.x-@frame.xoffset)/@frame.length
      py = 1 - (p.y-@frame.yoffset)/@frame.length
      if @frame.move?
	@vxmin,@vxmax,@vymin,@vymax, = @frame.released(px,py)
	draw(w)
      end
    }
    @draw_area.signal_connect("motion_notify_event"){|w,p|
      px = (p.x-@frame.xoffset)/@frame.length
      py = 1 - (p.y-@frame.yoffset)/@frame.length
      if @frame.move?
	expose_event(w)
	@frame.draged(w,px,py)
      end
    }
    @draw_area.set_events(Gdk::BUTTON_PRESS_MASK|Gdk::BUTTON_MOTION_MASK|Gdk::BUTTON_RELEASE_MASK)
    @draw_area.show
    @window = Gtk::Window.new(Gtk::WINDOW_TOPLEVEL)
    @window.signal_connect("delete_event"){|w,p| w.hide; true}
    @window.signal_connect("destroy_event"){exit}
    @window.signal_connect("key_press_event"){|w,e|
      key = e.string
      p key+" key press"
      if key=="q" then
	w.hide
      elsif key=="\r" || key==" " then
	$main.draw_next
      end
    }
    @window.add(@draw_area)
    @window.set_title(@filename)
    @window.show
  end
  def save_code(filename)
    file = File.open(filename,"w")
    file.print(@fig.head+"\n\n")
    file.print(@fig.var+"\n\n")
    file.print(@fig.open+"\n\n")
    file.print(@fig.draw+"\n\n")
    file.print(@fig.close+"\n\n")
    file.close
  end
  def save_image(filename)
    geom = @pixmap.get_geometry
    mask = Gdk::Bitmap.new(@draw_area.window, geom[2], geom[3])
    im = GdkImlib::Image.create_from_drawable(@pixmap, mask, geom[0], geom[1], geom[2], geom[3])
    begin
      im.save(filename)
      p "save image to #{filename}"
    rescue
      dialog = Gtk::Dialog.new.set_title("Error Message")
      dialog.set_modal(true)
      image_type = File.basename(filename).sub(File.basename(filename,".*"),"")
      dialog.vbox.pack_start(Gtk::Label.new("Image type: "+image_type.upcase+" is not suported"))
      ok_button=Gtk::Button.new("OK")
      ok_button.signal_connect("clicked"){dialog.destroy}
      dialog.action_area.pack_start(ok_button)
      dialog.show_all
    end
  end

  private
  def set_env
    DCL::swlset("LWAIT", false )
    @fig.parm_set('DCL::sglset("LCNTL", false )')
    @fig.parm_set('DCL::udlset("LMSG", false )')

    if @miss and @miss.to_f!=0 then
      @fig.parm_set('DCL::gllset("LMISS", true )')
      @fig.parm_set("DCL::glrset(\"RMISS\", #{@miss})")
    end
  end

  private
  def axis
    @fig.figure_set('DCL::ussttl(x_title, x_unit, y_title, y_unit)')
    @fig.figure_set('DCL::usdaxs')
    @fig.figure_set('DCL::sglset("LCLIP", false )')
    i=0
    @gphys.lost_axes.each{|info|
      @fig.figure_set("i=#{i}")
      @fig.figure_set("DCL::sgtxzv(vxmax+0.01,vymax-0.03*i,\"#{info}\",0.02,0,-1,1)")
      i+=1
    }
  end

  private
  def draw_1d(title)
    @fig.figure_set('DCL::sgplzu(gphys.coord(0).val, gphys.val, 1, 3 )')
    axis
    @fig.figure_set("title = \"#{title}\"")
    @fig.figure_set('DCL::uxsttl("t", title, 0 )')
  end

  private
  def draw_2d(title,type)
#    if type==MAP then
#      tmp = NArray.sfloat(@axisx.length+1)
#      tmp[0..-2] = @axisx
#      tmp[-1] = @axisx[-1] + (@axisx[-1]-@axisx[0])/(@axisx.length-1)
#      @axisx = tmp
#      @var.reshape!(@axisx.length-1,@axisy.length)
#      tmp = NArray.sfloat(@axisx.length, @axisy.length)
#      tmp[0..-2,true] = @var
#      tmp[-1,true] = @var[0,true]
#      @var = tmp
#    end
    if @transpose then
      x = 1
      y = 0
    else
      x = 0
      y = 1
    end
    @fig.figure_set("DCL::uwsgxa(gphys.coord(#{x}).val)")
    @fig.figure_set("DCL::uwsgya(gphys.coord(#{y}).val)")
    @fig.figure_set('DCL::ueitlv')
    if @tone.nil?
      min = @gphys.val.min
      max = @gphys.val.max
      dm = 0
    else
      min,dm = @tone
      max = min+dm*(50-1)
    end
    if min!=max then
      @fig.figure_set("DCL::uegtla(#{min}, #{max}, #{dm} )")
    end
    if @transpose
      @fig.figure_set("DCL::uetonf(gphys.val.transpose(#{x},#{y}))")
    else
      @fig.figure_set("DCL::uetonf(gphys.val)")
    end
    if @cont.nil?
      min = @gphys.val.min
      max = @gphys.val.max
      dm = 0
    else
      min,dm = @cont
      max = min+dm*(50-1)
    end
    if min!=max then
      @fig.figure_set("DCL::udgcla(#{min}, #{max}, #{dm} )")
    end
    if @transpose
      @fig.figure_set("DCL::udcntz(gphys.val.transpose(#{x},#{y}))")
    else
      @fig.figure_set("DCL::udcntz(gphys.val)")
    end
    if type==CONTOUR then
      axis
      @fig.figure_set('DCL::uzrset("ROFFXT", 0.06)')
      @fig.figure_set("title = \"#{title}\"")
      @fig.figure_set('DCL::uxsttl("t", title, 0 )')
    elsif type==MAP then
      @fig.figure_set("DCL::umpglb")
      @fig.figure_set('DCL::sglset("LCLIP", false )')
      @fig.figure_set("title = \"#{title}\"")
      @fig.figure_set("DCL::sgtxzv((vxmax+vxmin)/2,vymax+0.02,title,0.02,0.0,0,2)")
      @fig.figure_set('DCL::sglset("LCLIP", true )')
    end
  end

  private
  def draw(drawing_area)
    @fig.window_set(@xmin,@xmax,@ymin,@ymax)
    @fig.viewport_set(@vxmin,@vxmax,@vymin,@vymax)
    @fig.frame_clear
    @fig.figure_clear
    if @type == MAP then
      itr = @maptype
      p itr
      @fig.frame_set("DCL::grfrm")
#      @fig.frame_set("DCL::grswnd(xmin,xmax,ymin,ymax)")
      @fig.frame_set("DCL::grsvpt(vxmin,vxmax,vymin,vymax)")
#      @fig.frame_set("DCL::grssim((vxmax-vxmin)/2,0.0,0.0)")
      @fig.frame_set("DCL::grsmpl(0.0,90.0,0.0)")
#      @fig.frame_set("DCL::grstxy(xmin,xmax,ymin,ymax)")
      @fig.frame_set("DCL::grstrn(#{itr})")
      @fig.frame_set("DCL::umpfit")
      @fig.frame_set("DCL::grstrf")
    else
      itr = 1
      itr += 2 if @logx; itr += 1 if @logy
      @fig.frame_set("DCL::grfrm")
      @fig.frame_set("DCL::grswnd(xmin,xmax,ymin,ymax)")
      @fig.frame_set("DCL::grsvpt(vxmin,vxmax,vymin,vymax)")
      @fig.frame_set("DCL::grstrn(#{itr})")
      @fig.frame_set("DCL::grstrf")
    end
    @fig.figure_set('DCL::sglset("LCLIP", true )')
    if @type == LINE then
      draw_1d(@title)
    elsif (@type==CONTOUR) || (@type==MAP) then
      draw_2d(@title,@type)
    end
    gphys = @gphys
    eval(@fig.draw)
    expose_event(drawing_area)
  end

  private
  def expose_event(widget,event=nil)
    if ! @pixmap.nil?
      gc = widget.style.fg_gc(widget.state)
      if event.nil?
	geom = widget.window.get_geometry
      else
	area = event.area
	geom = [area.x,area.y,area.width,area.height]
      end
      widget.window.draw_pixmap(gc, @pixmap, geom[0], geom[1],
				geom[0],geom[1], geom[2], geom[3])
    end
    false
  end

  private
  def configure_event(widget)
    geom = widget.window.get_geometry
    if (geom[2]>0 && geom[3]>0) then
      @pixmap = Gdk::Pixmap.new(widget.window, geom[2], geom[3], -1)
      @pixmap.draw_rectangle(widget.style.white_gc, true, 0, 0, 
			    geom[2], geom[3])
    end
    DCL::zgsdrw(widget)
    DCL::zgspmp(@pixmap)
    if !@opened then
      DCL::sgopn(4)
      @opened = true
    end
    draw(widget)
    true
  end

  private
  class Fig
    attr_reader :head, :var, :open, :close
    def initialize
      @head = ""
      @var = ""
      @open = ""
      @parm = Array.new
      @window = Array.new
      @viewport = Array.new
      @frame = Array.new
      @title = Array.new
      @figure = Array.new
      @close = ""
      @head = <<"END"
require "gtk"
require "numru/gphys"
require "numru/dcl"
require "numru/netcdf"

include NumRu
END
      @open = "DCL::gropn(1)"
      ymin=@ymin; ymax=@ymax
      vxmin=@vxmin; vxmax=@vxmax
      vymin=@vymin; vymax=@vymax
      @window[0] = "xmin = axisx[0]"
      @window[1] = "xmax = axisx[-1]"
      @window[2] = "ymin = 0.0"
      @window[3] = "ymax = 1.0"
      @viewport[0] = "vxmin = 0.2"
      @viewport[1] = "vxmax = 0.8"
      @viewport[2] = "vymin = 0.2"
      @viewport[3] = "vymax = 0.8"
      @title[0] = 'x_title = ""'
      @title[1] = 'x_unit = ""'
      @title[2] = 'y_title = ""'
      @title[3] = 'y_unit = ""'
      @close = "DCL::grcls"
    end
    def var_set(filename,varname,funcs,mapping)
      varname = funcs[0] if funcs.length!=0
      @var = <<"END"
filename = "#{filename}"
varname = "#{varname}"

gphys = GPhys::NetCDF_IO.open(filename,varname)
END
      if funcs.length!=0
	funcs[1..-1].each{|func|
	  @var += "gphys = gphys.#{func[0]}(#{func[1]})\n"
	}
      end
      @var += "gphys = gphys[#{mapping.join(",")}]"
    end
    def parm_set(str)
      @parm.push(str)
    end
    def window_set(xmin,xmax,ymin,ymax)
      @window[0] = "xmin = #{xmin}"
      @window[1] = "xmax = #{xmax}"
      @window[2] = "ymin = #{ymin}"
      @window[3] = "ymax = #{ymax}"
    end
    def viewport_set(vxmin,vxmax,vymin,vymax)
      @viewport[0] = "vxmin = #{vxmin}"
      @viewport[1] = "vxmax = #{vxmax}"
      @viewport[2] = "vymin = #{vymin}"
      @viewport[3] = "vymax = #{vymax}"
    end
    def frame_clear
      @frame.clear
    end
    def frame_set(str)
      @frame.push(str)
    end
    def title_set(xt,xu,yt,yu)
      @title[0] = "x_title = \"#{xt}\""
      @title[1] = "x_unit = \"#{xu}\""
      @title[2] = "y_title = \"#{yt}\""
      @title[3] = "y_unit = \"#{yu}\""
    end
    def figure_clear
      @figure.clear
    end
    def figure_set(str)
      @figure.push(str)
    end
    def draw
      [@parm.join("\n"),
      @window.join("\n"),
      @viewport.join("\n"),
      @frame.join("\n"),
      @title.join("\n"),
      @figure.join("\n")].join("\n\n")
    end
  end
end
