#
# uupk02.rb
#
# $Id: uupk02.rb,v 1.1 2000/11/23 08:19:14 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 20
m = 5
x0 = NArray.sfloat(n)
x1 = NArray.sfloat(n)
x2 = NArray.sfloat(n)
y0 = NArray.sfloat(n)
y1 = NArray.sfloat(n)
y2 = NArray.sfloat(n)
a = NArray.sfloat(m)

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

for i in 0..n-1
  t = dt*i*2*PI
  x0[i] = dt*i
  y1[i] = a[0]*cos(t)
  y2[i] = 0.0
  for j in 0..m-1
    jj = j*2+1
    yy = a[j]*cos(jj*t)
    y2[i]  = y2[i] + yy
  end

  y0[i] = (y1[i]+y2[i])/2.0
  dy = (y1[i] - y2[i]).abs
  x1[i] = x0[i] - dy/5
  x2[i] = x0[i] + dy/5
end

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::sglset('LCLIP', true)

DCL::usspnt(x0, y0)
DCL::usspnt(x1, y1)
DCL::usspnt(x2, y2)
DCL::uspfit
DCL::grstrf

DCL::usdaxs

DCL::uverb(x0, y1, y2)

DCL::uusebt(3)
DCL::uusebi(33)
DCL::uherb(x1, x2, y0)

DCL::uusmkt(4)
DCL::uusmki(21)
DCL::uumrk(x0, y0)

DCL::grcls

