require 'rbconfig'
require 'find'
require "ftools"
require 'getopts'

CONFIG = Config::MAKEFILE_CONFIG

a=getopts(nil, 'prefix:')
if a>=2
  raise StandardError, "too many option"
end

prefix = CONFIG["prefix"]
libdir = prefix+"/lib/ruby/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/dcl"
sitelibdir = CONFIG["sitedir"]+"/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/dcl"
sitelibdir.gsub!(/\$\(prefix\)/, CONFIG["prefix"])

if $OPT_prefix
  libdir = $OPT_prefix+"/lib/ruby/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/dcl"
  sitelibdir = CONFIG["sitedir"]+"/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/dcl"
  sitelibdir.gsub!(/\$\(prefix\)/, $OPT_prefix)
end 

srcdir = File.dirname($0)

print "press key 1 or 2 (1:install, 2:site-install)\n"
install = gets.chomp.to_i

if(install == 1)
  Dir[File.join(srcdir || ".", "*.rb")].each{|file|
    if(/install.rb/ =~ file)
    else
      file = File.basename(file)
      File::makedirs(libdir)
      File::install(file, libdir+"/"+file, 0644, true)
  end
  }
elsif(install == 2)
  Dir[File.join(srcdir || ".", "*.rb")].each{|file|
    if(/install.rb/ =~ file)
    else
      file = File.basename(file)
      File::makedirs(sitelibdir)
      File::install(file, sitelibdir+"/"+file, 0644, true)
  end
  }
else
  raise ArgumentError, "failed to install"
end
