require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


nx = 11
ny = 11
xmin = -1
xmax = 1
ymin = -1
ymax = 1
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    x = xmin + (xmax-xmin)*i/(nx-1).to_f
    y = ymin + (ymax-ymin)*j/(ny-1).to_f
    u[i,j] =  x * 0.1
    v[i,j] = -y
  end
end

#-- graph ---

Dev.open("X")

Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Axis.draw

Vector.lnrmal=false
Vector.xfact1=0.5
Vector.yfact1=0.05
Vector.lunit=true
Vector.vxunit=0.1
Vector.vyunit=0.1
Vector.vxuoff=0.06
Vector.uvtitle('X', 'U')
Vector.uvtitle('Y', 'V')
Vector.draw(u, v)

Dev.close
