require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath

nx = 21
ny = 21
xmin = -10.0
xmax = 10.0
ymin = -10.0
ymax = 10.0
kmax = 5
pmin = 0.0
pmax = 1.0
dx = (xmax-xmin)/(nx-1)
dy = (ymax-ymin)/(ny-1)
dp = (pmax-pmin)/kmax

u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)
p = NArray.sfloat(nx, ny)


#-- data ----
for j in 0..ny-1
  for i in 0..nx-1
    xi = xmin + i*dx
    yj = ymin + j*dy
    u[i, j] = xi
    v[i, j] = -yj
    p[i, j] = exp(-xi**2/64 - yj**2/25)
  end
end

#-- graph ----

Dev.open("X")
Tone.lsoftf=true
Frame.new

Fig.window=[xmin, xmax, ymin, ymax]

Axis.draw
Vector.draw(u, v)
Contour.draw(p)

for k in 0..kmax-1
  tlev1 = k*dp
  tlev2 = tlev1 + dp
  ipat  = 600 + k
  Tone.stlv(tlev1, tlev2, ipat)
end

Tone.draw(p)

Dev.close
