require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath

nx = 21
ny = 21
xmin = -1.0
xmax = 1.0
ymin = -1.0
ymax = 1.0
dx = (xmax-xmin)/(nx-1)
dy = (ymax-ymin)/(ny-1)

u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)

#-- data ----
for j in 0..ny-1
  for i in 0..nx-1
    xi = xmin + i*dx
    yj = ymin + j*dy
    u[i,j] = xi
    v[i,j] = -yj
  end
end

#-- graph ----
Dev.open("X")
Frame.new

Fig.window=[xmin, xmax, ymin, ymax]

Axis.title('X', 'km', 'Y', 'km')
Axis.draw

Vector.draw(u, v)

Dev.close
