require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


id0 = 19811201
nd = 180
rnd = nd

#-- graph ---
Dev.open

Axis.zfact(0.7)
Axis::Lin.loffset=true

Frame.new

Fig.window=[0.0, rnd, 0.0, 100.0]
Fig.viewport=[0.4, 0.9, 0.3, 0.8]
Fig.transnum=1

Fig.pvpr(1)

Dateaxis.xdraw('B', id0, nd)
Axis::Lin.xsaxs('B')
Axis::Lin.xaxdv('B', 10.0, 20.0)
Axis::Lin.xsttl('B', 'DAY NUMBER', 0.0)
Dateaxis.xdraw('T', id0, nd)

Axis::Lin.yaxdv('L', 5.0, 10.0)
Axis::Lin.yaxdv('R', 5.0, 10.0)
Axis::Lin.ysttl('L', 'CELSIUS SCALE', 0.0)
Axis::Lin.ysaxs('L')
Axis::Lin.yoffset=273.15
Axis::Lin.yfact=1.0
Axis::Lin.yaxdv('L', 5.0, 10.0)
Axis::Lin.ysttl('L', 'KELVIN SCALE', 0.0)
Axis::Lin.ysaxs('L')
Axis::Lin.yoffset=32.0
Axis::Lin.yfact= 1.8
Axis::Lin.yaxdv('L', 10.0, 20.0)
Axis::Lin.ysttl('L', 'FAHRENHEIT SCALE', 0.0)

Axis::Lin.xsttl('T', '( LOFSET=.TRUE. )', 0.0)
Axis::Lin.xsttl('T', 'UXSAXS/UYSAXS', 0.0)

Dev.close
