require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


id0 = 19811201
nd = 180
rnd = nd
rlat1 = 20
rlat2 = 80
dlat1 = 5
dlat2 = 10

#-- graph ---
Dev.open

Axis.zfact(0.7)
Frame.new

Fig.window=[0.0, rnd, rlat1, rlat2]
Fig.viewport=[0.2, 0.8, 0.4, 0.8]
Fig.transnum=1

Axis::Lin.xsaxs('B')
Dateaxis.xdraw('B', id0, nd)
Axis::Lin.xsaxs('B')
Axis::Lin.xaxdv('B', 10.0, 20.0)
Axis::Lin.xsttl('B', 'DAY NUMBER', 0.0)
Axis::Lin.xsaxs('T')
Dateaxis.xdraw('T', id0, nd)

Axis::Lin.ysaxs('L')
Axis::Lin.yaxdv('L', dlat1, dlat2)
Axis::Lin.ysaxs('R')
Axis::Lin.yaxdv('R', dlat1, dlat2)
Axis::Lin.ysttl('L', 'LATITUDE', 0.0)

Axis::Lin.xmttl('T', 'UXSAXS/UYSAXS', 0.0)

Fig.pvpr(1)

Dev.close
