require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


n = 20
m = 5
y1 = NArray.sfloat(n)
y2 = NArray.sfloat(n)
a = NArray.sfloat(m)
rundef = Fig.rundef

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

for i in 0..n-1
  t = dt*i*2*PI
  y1[i] = a[0]*cos(t)
  y2[i] = 0.0
  for j in 0..m-1
    jj = j*2+1
    yy = a[j]*cos(jj*t)
    y2[i]  = y2[i] + yy
  end

end

#-----------------------------------------------------------------------
Dev.open("X")

Frame.new
Fig.lclip=true

Fig.inclpoint=[rundef, y1]
Fig.inclpoint=[rundef, y2]
Fig.window=[0.0, 1.0, rundef, rundef]

Axis.draw

Bar.itpat=[2999, 3999]
Bar.xtone(rundef, y1, y2)
Bar.xfrm(rundef, y1, y2)

Bar.lineindex=41
Bar.xline(rundef, y1)
Bar.linetype=3
Bar.xline(rundef, y2)

Frame.new

Fig.inclpoint=[y1, rundef]
Fig.inclpoint=[y1, rundef]
Fig.window=[rundef, rundef, 0.0, 1.0]

Axis.draw

Bar.itpat=[2999, 3999]
Bar.ytone(y1, y2, rundef)
Bar.yfrm(y1, y2, rundef)

Bar.lineindex=41
Bar.yline(y1, rundef)
Bar.linetype=3
Bar.yline(y2, rundef)

Dev.close

