require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


n = 30
y = NArray.sfloat(n)

#---------------------------- DATA DEFINITION --------------------------
r = 0.2
a = 3.7
for i in 0..n-1
  r = a*r*(1.0-r)
  y[i] = r
end

y[n/2-1] = 999.0
Fig.lmiss = true
rundef = Fig.rundef

#----------------------------- GRAPH -----------------------------------

Dev.open("X")

Frame.new

Fig.window=[0.0, 1.0, rundef, rundef]
Fig.inclpoint=[rundef, y]

Axis.draw

Box.xline(rundef, y)

Frame.new

Fig.window=[rundef, rundef, 0.0, 1.0]
Fig.inclpoint=[y, rundef]

Axis.draw

Box.yline(y, rundef)

Dev.close

