require "narray"
require "dcl/advanced"

include AdvancedDCL


n = 181
n1 = 26
n2 = 7
nc = 4
t = NArray.sfloat(n)
y = NArray.sfloat(n)
ux1 = NArray.sfloat(n1)

#-----------------------------------------------------------------------
ch = ['JAN', 'FEB', 'MAR', 'APL', 'JUN', 'JULY', '   ']
ux2 = NArray[0.0, 31.0, 59.0, 90.0, 120.0, 151.0, 181.0]

r = 0.2
a = 4.0
y[0] = 120.0
t.indgen(0.5, 1.0)
for i in 1..n-1
  r = a*r*(1.0-r)
  y[i] = y[i-1] + (r-0.46)*2
end

ux1.indgen(1.0, 7.0)

#-----------------------------------------------------------------------

Axis.lyinv=true

Dev.open("X")
Frame.new

#Fig.window(0.0, 181.0, rundef, rundef)
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

#------------------------------- Y-AXIS --------------------------------
Axis.yax('L', t, y)
Axis.yax('R')
Axis::Lin.ysttl('L', 'YEN/DOLLAR', 0.0)

#------------------------------- X-AXIS --------------------------------
Axis::Lin.lbtwn=true
Axis::Lin.xaxlb('B', ux1, ux2, ch)
Axis::Lin.xaxlb('T', ux1, ux2, ch)
Axis::Lin.xsttl('T', 'EXCHANGE RATE', 0.0)

#-------------------------------- LINE ---------------------------------
Plot.draw(t, y)

Dev.close

