require "narray"
require "dcl/advanced"

include AdvancedDCL
include Math


n = 200
m = 5
x = NArray.sfloat(n)
y = NArray.sfloat(n)
yc = NArray.sfloat(n, m)
a = Array.new(m)

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
j  = NArray.sfloat(m).indgen
jj = j*2+1
for i in 0..m-1
  a[i] = (-1.0)**(j[i]+1) *2.0/(jj[i]*PI)
end

for i in 0..n-1
  t = dt*i*2*PI
  x[i] = dt*i
  y[i] = 0.0
  for j in 0..m-1
    jj = j*2+1
    yc[i, j] = a[j]*cos(jj*t)
    y[i]  = y[i] + yc[i, j]
  end
end

#--------------------------- 1ST PAGE ----------------------------------
Dev.open("X")

Frame.new
Fig.viewport=[0.2, 0.8, 0.2, 0.6]
Fig.window=[0.0, 1.0, -0.7, 0.7]

Axis.title('X-AXIS', ' ', 'COMPONENTS', ' ')
Axis.draw
Plot.draw(x, yc[0..-1, 0])

for j in 1..m-1
  ip = j.divmod(4)[1] + 1
  Plot.draw(x, yc[0..-1, j], {"linetype"=>1, "lineindex"=>ip})
end

#     --- NEW FIG ---
Fig.new
Fig.viewport=[0.2, 0.8, 0.62, 0.82]
Fig.window=[0.0, 1.0, -0.6, 0.6]
Axis.labelxb=false

Axis.title(' ', ' ', 'TOTAL', ' ')
Axis.draw
Axis::Lin.xaxdv('B', 0.05, 0.2)
Axis.xax('T')
Axis.yax('L')
Axis.yax('R')
Plot.draw(x, y)

#--------------------------- 2ND PAGE ----------------------------------
Frame.new
Axis.zfact(0.5)
Fig.viewport=[0.2, 0.8, 0.2, 0.6]
Fig.window=[0.0, 1.0, -0.7, 0.7]
Axis.labelxb=true

Axis.title('X-AXIS', ' ', 'COMPONENTS', ' ')
Axis.xax('B')
Axis.yax('L')
Axis.xax('T')
Axis.yax('R')
Plot.draw(x, yc[0..-1, 0])

for j in 1..m-1
  ip = j.divmod(4)[1] + 1
  Plot.draw(x, yc[0..-1, j], {"linetype"=>1, "lineindex"=>ip})
end

#     --- NEW FIG ---
Fig.new
Fig.viewport=[0.2, 0.8, 0.62, 0.82]
Fig.window=[0.0, 1.0, -0.6, 0.6]
Axis.labelxb=false

Axis.title(' ', ' ', 'TOTAL', ' ')
Axis.xax('B')
Axis.xax('T')
Axis.yax('L')
Axis.yax('R')
Plot.draw(x, y)

Dev.close
