require "dcl/advanced"

include AdvancedDCL
include Math

n = 200
t = Array.new(n)
z = Array.new(n)

#-----------------------------------------------------------------------
r = 0.2
a = 4.0
for i in 0..n-1
  r = a*r*(1.0-r)
  z2  = ((i-4).to_f/40.0)**2
  t[i] = 20.0*exp(-z2) + r*2.0
  z[i] = (i+1)*2.0
end

#-----------------------------------------------------------------------
Dev.open("X")

Frame.new
Fig.window=[0.0, 25.0, 0.0, 400.0]

Axis.lyinv=true
Axis.labelxt=true
Axis.cyspos='B'

Axis.title('TEMPERATURE', 'C|'+ DCL.csgi(4) + '"', 'DEPTH', 'm')

Axis.xax("T")
Axis.yax("L")
Plot.draw(t, z)

Dev.close

