require "dcl/advanced"

include AdvancedDCL
include Math


n = 200
m = 10
x = Array.new(n)
y = Array.new(n)
a = Array.new(m)

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

for i in 0..n-1
  t = dt*i*2*PI
  x[i] = dt*(i-1) 
  yy = 0.0
  for j in 0..m-1
    jj = j*2+1
    yd = a[j]*cos(jj*t)
    yy = yy + yd
  end
  y[i] = yy*2.0
end

#-----------------------------------------------------------------------
Dev.open("X")

Frame.new
Fig.window=[0.0, 1.0, -1.5, 1.5]
#      --- X AXIS ---
Axis.uyuser=0.0
Axis.cxside='U'

#      --- Y AXIS ---
Axis::Lin.irotlyl=1
Axis::Lin.icentyl=0
Axis.cyside='L'

#      --- etc. ---
Axis::Lin.inner=-1
Axis.cblkt='[]'

Axis.title('TIME', 'SEC', 'VOLTAGE', 'mV')
#Fig.inclpoint=[x, y]
Axis.xax("U")
Axis.yax("L")
Plot.draw(x, y)

Dev.close
