require "dcl/advanced"

include AdvancedDCL
include Math

n = 400

x = Array.new(n)
y = Array.new(n)

dt = 3.14159 / (n-1)
a = 1.0e5
b = 1.0e-4
c = 1.0

(0..(n-1)).each{|i|
  t = dt * i
  x[i] = a * sin(6.0*t)
  y[i] = b * cos(14.0*t) + c
}

Dev.open("X") 

Frame.new
Fig.inclpoint=[x, y]

Axis.draw
Plot.draw(x, y)

Dev.close


