require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


nx = 37
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = +90
drad = PI / 180
dz = 0.05
fact = 10
p = NArray.sfloat(nx, ny)
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)
alon = NArray.sfloat(nx)
alat = NArray.sfloat(ny)

#-- data ---
alon.indgen(xmin, (xmax-xmin)/(nx-1).to_f)
alat.indgen(ymin, (ymax-ymin)/(ny-1).to_f)

for j in 0..ny-1
  for i in 0..nx-1
    slat = sin(alat[j]*drad)
    p[i,j] = cos(alon[i]*drad) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

rmiss = Fig.rmiss
Fig.lmiss = true

for j in 0..ny-1
  for i in 0..nx-1
    if (j == 0 || j == ny-1)
      u[i,j] = rmiss
      v[i,j] = rmiss
    else
      u[i,j] = (p[i,j-1] - p[i,j+1]) * fact
      v[i,j] = (p[imod(i+1,nx-1),j] - p[imod(i-1,nx-1),j]) * fact
    end
  end
end

#-- graph ---
Dev.open("X")

Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.1, 0.9, 0.1, 0.9]
Fig.simtrans=[0.4, 0.0, 0.0]
Fig.mapangle=[165.0, 60.0, 0.0]
Fig.mapwindow=[-180.0, 180.0, 0.0, 90.0]
Fig.transnum = 30

Fig.lclip = true

Map.open('coast_world')
Map.draw

Contour.draw(p)

Arrow.arrowindex = 3
Arrow.arrowtype = 1
for j in 0..ny-1
  for i in 0..nx-1
    if (!(u[i,j] == rmiss || v[i,j] == rmiss))
      Arrow.draw(alon[i],alat[j],alon[i]+u[i,j],alat[j]+v[i,j])
    end
  end
end

Dev.close

