require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


nx = 19
ny = 19
xmin = 0
xmax = 360
ymin = -90
ymax = +90
drad = PI/180
dz = 0.05
dp = 0.2
p = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

#-- graph ---
Dev.open("X")

rmiss = Fig.rmiss
Tone.lsoftf = false

Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.1, 0.9, 0.1, 0.9]
Fig.simtrans=[0.4, 0.0, 0.0]
Fig.mapangle=[165.0, 60.0, 0.0]
Fig.mapwindow=[-180.0, 180.0, 0.0, 90.0]
Fig.transnum = 30

Fig.lclip = true

Map.open('coast_world')
Map.draw

Tone.stlv(rmiss, -dp, 201)
Tone.stlv(dp, dp*2, 401)
Tone.stlv(dp*2, rmiss, 402)
Tone.draw(p)

Contour.gclb(p, dp)
Contour.draw(p)

Dev.close

