require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


np = 14

#-- data ---
ntr = [10,   11,   12,   13,   14,   15,   20,
       21,   22,   23,   30,   31,   32,   33]

#-- graph ---
Dev.open("X", true)

Frame.rat(2.0, 3.0)
Frame.div('Y', 2, 3)

Common.indexmj = 1
Map.itypemn = 1

Fig.viewport=[0.1, 0.9, 0.1, 0.9]
Fig.lclip = true

for i in 0..np-1
  Frame.new

  Fig.transnum = ntr[i]
  Fig.pwwr(1)
  Fig.pvpr(1)
  cttl = Fig.trn2lname(ntr[i])
  
  Map.open('coast_world')
  Map.draw

  Text.rdraw(0.5, 0.95, cttl, {"charsize"=>0.03, "charrot"=>0, "charcent"=>0, "charindex"=>3})
  
  if ( ntr[i] == 23 )
    Frame.new
    Frame.new
  end
end

Dev.close

