require "narray"
require "dcl/advanced"

include AdvancedDCL
include Math


nx = 19
ny = 19
xmin = 0
xmax = 360
dx1 = 20
dx2 = 60
ymin = -90
ymax = +90
dy1 = 10
dy2 = 30
drad = PI/180
dz = 0.05
dp = 0.2
p = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end


#-- graph ---
Dev.open("X")

rmiss = DCL.glrget('RMISS')
Tone.lsoftf=false

Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

Tone.stlv(rmiss, -dp, 201)
Tone.stlv(dp, dp*2, 401)
Tone.stlv(dp*2, rmiss, 402)
Tone.draw(p)

Axis::Lin.xaxdv('B', dx1, dx2)
Axis::Lin.xaxdv('T', dx1, dx2)
Axis::Lin.xsttl('B', 'LONGITUDE', 0.0)

Axis::Lin.yaxdv('L', dy1, dy2)
Axis::Lin.yaxdv('R', dy1, dy2)
Axis::Lin.ysttl('L', 'LATITUDE', 0.0)

Contour.gclb(p, dp)
Contour.draw(p)

Dev.close
