require "dcl/advanced"

include AdvancedDCL
include Math

kmax = 4
nn = 73
dd = 2.0
xorg = [2.5, 7.5, 2.5, 7.5]
yorg = [7.5, 7.5, 2.5, 2.5]
ux = Array.new(nn)
uy = Array.new(nn)

Dev.open("X")
Frame.new

Fig.window=[0.0, 10.0, 0.0, 10.0]
Fig.viewport=[0.0, 1.0, 0.0, 1.0]
Fig.transnum=1

Text.charsize=0.03
Text.charindex=3
Text.charcent=0

Plot.setlabel("K=1")

(0..(kmax-1)).each{|i|
  Plot.lineindex=1
  Plot.draw([xorg[i]-dd, xorg[i]+dd], [yorg[i], yorg[i]])
  Plot.draw([xorg[i], xorg[i]], [yorg[i]-dd, yorg[i]+dd])
  
  (0..(nn-1)).each{|j|
    th = 2*PI*j/(nn-1)
    ux[j] = xorg[i] + dd * cos(th + i*PI/7)
    uy[j] = yorg[i] + dd * sin((i+1)*th)
  }

  Plot.lineindex=2
  Plot.linetype=i+1
  Plot.lchar=true
  Plot.draw(ux, uy)
  Plot.lchar=false
  Plot.nplc
  Plot.linetype=1
}

Dev.close

